/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.client;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.standby.client.SegmentLoaderHandler;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.Messages;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.RecordIdDecoder;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.ReplyDecoder;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.CommunicationObserver;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.StandbyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandbyClientHandler
extends SimpleChannelInboundHandler<RecordId>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(StandbyClientHandler.class);
    private final StandbyStore store;
    private final CommunicationObserver observer;
    private final AtomicBoolean running;
    private final int readTimeoutMs;
    private final boolean autoClean;
    private EventExecutorGroup loaderExecutor;

    public StandbyClientHandler(StandbyStore store, CommunicationObserver observer, AtomicBoolean running, int readTimeoutMs, boolean autoClean) {
        this.store = store;
        this.observer = observer;
        this.running = running;
        this.readTimeoutMs = readTimeoutMs;
        this.autoClean = autoClean;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.debug("sending head request");
        ctx.writeAndFlush(Messages.newGetHeadReq(this.observer.getID()));
        log.debug("did send head request");
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, RecordId msg) throws Exception {
        this.setHead(ctx, msg);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    synchronized void setHead(ChannelHandlerContext ctx, RecordId head) {
        if (this.store.getHead().getRecordId().equals(head)) {
            log.debug("no changes on sync.");
            return;
        }
        log.debug("updating current head to " + head);
        ctx.pipeline().remove(ReadTimeoutHandler.class);
        ctx.pipeline().remove(RecordIdDecoder.class);
        ctx.pipeline().remove(this);
        ctx.pipeline().addLast(new ReplyDecoder(this.store));
        this.loaderExecutor = new DefaultEventExecutorGroup(4);
        SegmentLoaderHandler h2 = new SegmentLoaderHandler(this.store, head, this.loaderExecutor, this.observer.getID(), this.running, this.readTimeoutMs, this.autoClean);
        ctx.pipeline().addLast(this.loaderExecutor, h2);
        h2.channelActive(ctx);
        log.debug("updating current head finished");
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("Exception caught, closing channel.", cause);
        this.close();
    }

    @Override
    public synchronized void close() {
        if (this.loaderExecutor != null && !this.loaderExecutor.isShuttingDown()) {
            this.loaderExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS).syncUninterruptibly();
        }
    }
}

