/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.codec;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.api.Blob;

public class BlobEncoder
extends MessageToByteEncoder<Blob> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Blob b, ByteBuf out) throws Exception {
        byte[] bytes = null;
        InputStream s = b.getNewStream();
        try {
            bytes = IOUtils.toByteArray(s);
        }
        finally {
            s.close();
        }
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long hash = hasher.putBytes(bytes).hash().padToLong();
        out.writeInt(bytes.length);
        out.writeByte(2);
        String bid = b.getContentIdentity();
        byte[] id = bid.getBytes(Charset.forName("UTF-8"));
        out.writeInt(id.length);
        out.writeBytes(id);
        out.writeLong(hash);
        out.writeBytes(bytes);
    }
}

