/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordIdDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(RecordIdDecoder.class);
    private final SegmentStore store;

    public RecordIdDecoder(SegmentStore store) {
        super(64, 0, 4, 0, 4);
        this.store = store;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            throw new IOException("Received unexpected empty frame. Maybe you have enabled secure transmission on only one endpoint of the connection.");
        }
        byte type = frame.readByte();
        frame.discardReadBytes();
        String id = frame.toString(CharsetUtil.UTF_8);
        try {
            log.debug("received type {} with id {}", (Object)type, (Object)id);
            return RecordId.fromString(this.store.getTracker(), id);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

