/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.codec;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.IdArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.SegmentReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplyDecoder
extends ReplayingDecoder<DecodingState> {
    private static final Logger log = LoggerFactory.getLogger(ReplyDecoder.class);
    private final SegmentStore store;
    private int length = -1;
    private byte type = (byte)-1;

    public ReplyDecoder(SegmentStore store) {
        super(DecodingState.HEADER);
        this.store = store;
    }

    private void reset() {
        this.checkpoint(DecodingState.HEADER);
        this.length = -1;
        this.type = (byte)-1;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch ((DecodingState)((Object)this.state())) {
            case HEADER: {
                this.length = in.readInt();
                this.type = in.readByte();
                switch (this.type) {
                    case 1: {
                        this.checkpoint(DecodingState.SEGMENT);
                        break;
                    }
                    case 2: {
                        this.checkpoint(DecodingState.BLOB);
                        break;
                    }
                    default: {
                        throw new Exception("Unknown type: " + this.type);
                    }
                }
                return;
            }
            case SEGMENT: {
                Segment s = this.decodeSegment(in, this.length, this.type);
                if (s != null) {
                    out.add(SegmentReply.empty());
                    ctx.fireUserEventTriggered(new SegmentReply(s));
                    this.reset();
                }
                return;
            }
            case BLOB: {
                IdArrayBasedBlob b = this.decodeBlob(in, this.length, this.type);
                if (b != null) {
                    out.add(SegmentReply.empty());
                    ctx.fireUserEventTriggered(new SegmentReply(b));
                    this.reset();
                }
                return;
            }
        }
        throw new Exception("Unknown decoding state: " + this.state());
    }

    private Segment decodeSegment(ByteBuf in, int len, byte type) {
        byte[] segment;
        long msb = in.readLong();
        long lsb = in.readLong();
        long hash = in.readLong();
        ByteBuf data = in.readBytes(len - 25);
        if (data.hasArray()) {
            segment = data.array();
        } else {
            segment = new byte[len - 25];
            in.readBytes(segment);
        }
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long check = hasher.putBytes(segment).hash().padToLong();
        if (hash == check) {
            SegmentId id = new SegmentId(this.store.getTracker(), msb, lsb);
            Segment s = new Segment(this.store.getTracker(), id, ByteBuffer.wrap(segment));
            log.debug("received segment with id {} and size {}", (Object)id, (Object)s.size());
            return s;
        }
        log.debug("received corrupted segment {}, ignoring", (Object)new UUID(msb, lsb));
        return null;
    }

    private IdArrayBasedBlob decodeBlob(ByteBuf in, int length, byte type) {
        byte[] blob;
        int inIdLen = in.readInt();
        byte[] bid = new byte[inIdLen];
        in.readBytes(bid);
        String id = new String(bid, Charset.forName("UTF-8"));
        long hash = in.readLong();
        ByteBuf data = in.readBytes(length);
        if (data.hasArray()) {
            blob = data.array();
        } else {
            blob = new byte[length];
            data.readBytes(blob);
        }
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long check = hasher.putBytes(blob).hash().padToLong();
        if (hash == check) {
            log.debug("received blob with id {} and size {}", (Object)id, (Object)blob.length);
            return new IdArrayBasedBlob(blob, id);
        }
        log.debug("received corrupted binary {}, ignoring", (Object)id);
        return null;
    }

    public static enum DecodingState {
        HEADER,
        SEGMENT,
        BLOB;

    }
}

