/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.codec;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.SegmentEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SegmentDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger log = LoggerFactory.getLogger(SegmentDecoder.class);
    private static final int MAX_LENGHT = 262144 + SegmentEncoder.EXTRA_HEADERS_LEN;
    private final SegmentStore store;

    public SegmentDecoder(SegmentStore store) {
        super(MAX_LENGHT, 0, 4, 0, 0);
        this.store = store;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf frame = (ByteBuf)super.decode(ctx, in);
        if (frame == null) {
            return null;
        }
        int len = frame.readInt();
        byte type = frame.readByte();
        long msb = frame.readLong();
        long lsb = frame.readLong();
        long hash = frame.readLong();
        byte[] segment = new byte[len - 25];
        frame.getBytes(29, segment);
        Hasher hasher = Hashing.murmur3_32().newHasher();
        long check = hasher.putBytes(segment).hash().padToLong();
        if (hash == check) {
            SegmentId id = new SegmentId(this.store.getTracker(), msb, lsb);
            Segment s = new Segment(this.store.getTracker(), id, ByteBuffer.wrap(segment));
            log.debug("received type {} with id {} and size {}", type, id, s.size());
            return s;
        }
        log.debug("received corrupted segment {}, ignoring", (Object)new UUID(msb, lsb));
        return null;
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

