/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.standby.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.IllegalRepositoryStateException;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.codec.Messages;
import org.apache.jackrabbit.oak.plugins.segment.standby.store.CommunicationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class StandbyServerHandler
extends SimpleChannelInboundHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(StandbyServerHandler.class);
    private final SegmentStore store;
    private final CommunicationObserver observer;
    private final String[] allowedIPRanges;
    public String state;

    public StandbyServerHandler(SegmentStore store, CommunicationObserver observer, String[] allowedIPRanges) {
        this.store = store;
        this.observer = observer;
        this.allowedIPRanges = allowedIPRanges;
    }

    private RecordId headId() {
        if (this.store != null) {
            return this.store.getHead().getRecordId();
        }
        return null;
    }

    private static long ipToLong(InetAddress ip) {
        byte[] octets = ip.getAddress();
        long result = 0L;
        for (byte octet : octets) {
            result <<= 8;
            result |= (long)(octet & 0xFF);
        }
        return result;
    }

    private boolean clientAllowed(InetSocketAddress client) {
        if (this.allowedIPRanges != null && this.allowedIPRanges.length > 0) {
            for (String s : this.allowedIPRanges) {
                try {
                    if (StandbyServerHandler.ipToLong(InetAddress.getByName(s)) == StandbyServerHandler.ipToLong(client.getAddress())) {
                        return true;
                    }
                }
                catch (UnknownHostException ignored) {
                    // empty catch block
                }
                int i = s.indexOf(45);
                if (i <= 0) continue;
                try {
                    long startIPRange = StandbyServerHandler.ipToLong(InetAddress.getByName(s.substring(0, i).trim()));
                    long endIPRange = StandbyServerHandler.ipToLong(InetAddress.getByName(s.substring(i + 1).trim()));
                    long ipl = StandbyServerHandler.ipToLong(client.getAddress());
                    if (startIPRange > ipl || ipl > endIPRange) continue;
                    return true;
                }
                catch (Exception e) {
                    log.warn("invalid IP-range format: " + s);
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.state = "channel registered";
        super.channelRegistered(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.state = "channel active";
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.state = "channel inactive";
        super.channelInactive(ctx);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.state = "channel unregistered";
        super.channelUnregistered(ctx);
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, String payload) throws Exception {
        this.state = "got message";
        String request = Messages.extractMessageFrom(payload);
        InetSocketAddress client = (InetSocketAddress)ctx.channel().remoteAddress();
        if (!this.clientAllowed(client)) {
            log.warn("Got request from client " + client + " which is not in the allowed ip ranges! Request will be ignored.");
        } else {
            String clientID = Messages.extractClientFrom(payload);
            this.observer.gotMessageFrom(clientID, request, client);
            if ("h".equalsIgnoreCase(request)) {
                RecordId r = this.headId();
                if (r != null) {
                    ctx.writeAndFlush(r);
                    return;
                }
            } else if (request.startsWith("s.")) {
                String sid = request.substring("s.".length());
                log.debug("request segment id {}", (Object)sid);
                UUID uuid = UUID.fromString(sid);
                Segment s = null;
                for (int i = 0; i < 10; ++i) {
                    try {
                        s = this.store.readSegment(new SegmentId(this.store.getTracker(), uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()));
                    }
                    catch (IllegalRepositoryStateException e) {
                        log.debug("waiting for segment. Got exception: " + e.getMessage());
                        TimeUnit.MILLISECONDS.sleep(2000L);
                    }
                    if (s != null) break;
                }
                if (s != null) {
                    log.debug("sending segment " + sid + " to " + client);
                    ctx.writeAndFlush(s);
                    this.observer.didSendSegmentBytes(clientID, s.size());
                    return;
                }
            } else {
                if (request.startsWith("b.")) {
                    String bid = request.substring("b.".length());
                    log.debug("request blob id {}", (Object)bid);
                    Blob b = this.store.readBlob(bid);
                    log.debug("sending blob " + bid + " to " + client);
                    ctx.writeAndFlush(b);
                    this.observer.didSendBinariesBytes(clientID, Math.max(0, (int)b.length()));
                    return;
                }
                log.warn("Unknown request {}, ignoring.", (Object)request);
            }
        }
        ctx.writeAndFlush(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        boolean isReadTimeout;
        this.state = "exception occurred: " + cause.getMessage();
        boolean bl = isReadTimeout = cause.getMessage() != null && cause.getMessage().contains("Connection reset by peer");
        if (isReadTimeout) {
            log.warn("Exception occurred: " + cause.getMessage(), cause);
        } else {
            log.error("Exception occurred: " + cause.getMessage(), cause);
        }
    }
}

