/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

class BinaryResource {
    private final ByteSource byteSource;
    private final String mimeType;
    private final String encoding;
    private final String path;
    private final String blobId;

    public BinaryResource(ByteSource byteSource, @Nullable String mimeType, @Nullable String encoding, String path, String blobId) {
        this.byteSource = Preconditions.checkNotNull(byteSource, "ByteSource must be provided");
        this.mimeType = mimeType;
        this.encoding = encoding;
        this.path = Preconditions.checkNotNull(path, "Path must be provided");
        this.blobId = Preconditions.checkNotNull(blobId, "BlobId must be specified");
    }

    public ByteSource getByteSource() {
        return this.byteSource;
    }

    @CheckForNull
    public String getMimeType() {
        return this.mimeType;
    }

    @CheckForNull
    public String getEncoding() {
        return this.encoding;
    }

    public String getPath() {
        return this.path;
    }

    public String getBlobId() {
        return this.blobId;
    }

    public String toString() {
        return this.path;
    }
}

