/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResource;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResourceProvider;
import org.apache.jackrabbit.oak.plugins.tika.TikaHelper;
import org.codehaus.groovy.runtime.StringGroovyMethods;

class BinaryStats {
    private final TikaHelper tika;
    private final List<MimeTypeStats> stats;
    private long totalSize;
    private long totalCount;
    private long indexedSize;
    private long indexedCount;

    public BinaryStats(File tikaConfig, BinaryResourceProvider provider) throws IOException {
        this.tika = new TikaHelper(tikaConfig);
        this.stats = this.collectStats(provider);
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getIndexedSize() {
        return this.indexedSize;
    }

    public long getIndexedCount() {
        return this.indexedCount;
    }

    public String getSummary() throws IOException {
        return this.getSummary(this.stats);
    }

    private List<MimeTypeStats> collectStats(BinaryResourceProvider provider) throws IOException {
        HashMap<String, MimeTypeStats> stats = Maps.newHashMap();
        for (BinaryResource binary : provider.getBinaries("/")) {
            String mimeType = binary.getMimeType();
            if (mimeType == null) continue;
            MimeTypeStats mimeStats = (MimeTypeStats)stats.get(mimeType);
            if (mimeStats == null) {
                mimeStats = this.createStat(mimeType);
                stats.put(mimeType, mimeStats);
            }
            long size = binary.getByteSource().size();
            mimeStats.addSize(size);
            this.totalSize += size;
            ++this.totalCount;
            if (!mimeStats.isIndexed()) continue;
            this.indexedSize += size;
            ++this.indexedCount;
        }
        ArrayList<MimeTypeStats> result = new ArrayList<MimeTypeStats>(stats.values());
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private String getSummary(List<MimeTypeStats> stats) {
        int maxWidth = 0;
        for (MimeTypeStats s : stats) {
            maxWidth = Math.max(maxWidth, s.getName().length());
        }
        maxWidth += 5;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("MimeType Stats");
        pw.printf("\tTotal size          : %s%n", IOUtils.humanReadableByteCount(this.totalSize));
        pw.printf("\tTotal indexed size  : %s%n", IOUtils.humanReadableByteCount(this.indexedSize));
        pw.printf("\tTotal count         : %d%n", this.totalCount);
        pw.printf("\tTotal indexed count : %d%n", this.indexedCount);
        pw.println();
        String header = BinaryStats.center("Type", maxWidth) + " " + BinaryStats.center("Indexed", 10) + " " + BinaryStats.center("Supported", 10) + " " + BinaryStats.center("Count", 10) + " " + BinaryStats.center("Size", 10);
        pw.println(header);
        pw.println(Strings.repeat("_", header.length() + 5));
        for (MimeTypeStats s : stats) {
            pw.printf("%-" + maxWidth + "s|%10s|%10s|  %-8d|%10s%n", s.getName(), s.isIndexed(), s.isSupported(), s.getCount(), IOUtils.humanReadableByteCount(s.getTotalSize()));
        }
        return sw.toString();
    }

    private MimeTypeStats createStat(String mimeType) {
        MimeTypeStats stats = new MimeTypeStats(mimeType);
        stats.setIndexed(this.tika.isIndexed(mimeType));
        stats.setSupported(this.tika.isSupportedMediaType(mimeType));
        return stats;
    }

    private static String center(String s, int width) {
        return StringGroovyMethods.center(s, (Number)width);
    }

    private static class MimeTypeStats
    implements Comparable<MimeTypeStats> {
        private final String mimeType;
        private int count;
        private long totalSize;
        private boolean supported;
        private boolean indexed;

        public MimeTypeStats(String mimeType) {
            this.mimeType = mimeType;
        }

        public void addSize(long size) {
            ++this.count;
            this.totalSize += size;
        }

        public void setSupported(boolean supported) {
            this.supported = supported;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public int getCount() {
            return this.count;
        }

        public String getName() {
            return this.mimeType;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public boolean isSupported() {
            return this.supported;
        }

        @Override
        public int compareTo(MimeTypeStats o) {
            return ComparisonChain.start().compareFalseFirst(this.indexed, o.indexed).compare(this.totalSize, o.totalSize).result();
        }
    }
}

