/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

class BlobStoreByteSource
extends ByteSource {
    private final BlobStore blobStore;
    private final String blobId;
    private final Long size;

    BlobStoreByteSource(BlobStore blobStore, String blobId, @Nullable Long size) {
        this.blobStore = blobStore;
        this.blobId = blobId;
        this.size = size;
    }

    BlobStoreByteSource(BlobStore blobStore, String blobId) {
        this(blobStore, blobId, null);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.blobStore.getInputStream(this.blobId);
    }

    @Override
    public long size() throws IOException {
        if (this.size != null) {
            return this.size;
        }
        return this.blobStore.getBlobLength(this.blobId);
    }
}

