/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.io.Closer;
import com.google.common.primitives.Longs;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResource;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResourceProvider;
import org.apache.jackrabbit.oak.plugins.tika.BlobStoreByteSource;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CSVFileBinaryResourceProvider
implements BinaryResourceProvider,
Closeable {
    private static final String BLOB_ID = "blobId";
    private static final String LENGTH = "length";
    static final CSVFormat FORMAT = CSVFormat.DEFAULT.withCommentMarker('#').withHeader("blobId", "length", "jcr:mimeType", "jcr:encoding", "jcr:path").withNullString("").withIgnoreSurroundingSpaces().withSkipHeaderRecord();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final File dataFile;
    private final BlobStore blobStore;
    private final Closer closer = Closer.create();

    public CSVFileBinaryResourceProvider(File dataFile, @Nullable BlobStore blobStore) {
        Preconditions.checkArgument(dataFile.exists(), "Data file %s does not exist", dataFile);
        this.dataFile = dataFile;
        this.blobStore = blobStore;
    }

    @Override
    public FluentIterable<BinaryResource> getBinaries(final String path) throws IOException {
        CSVParser parser = CSVParser.parse(this.dataFile, Charsets.UTF_8, FORMAT);
        this.closer.register(parser);
        return FluentIterable.from(parser).transform(new RecordTransformer()).filter(Predicates.notNull()).filter(new Predicate<BinaryResource>(){

            @Override
            public boolean apply(BinaryResource input) {
                return PathUtils.isAncestor(path, input.getPath());
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    private class RecordTransformer
    implements Function<CSVRecord, BinaryResource> {
        private RecordTransformer() {
        }

        @Override
        @Nullable
        public BinaryResource apply(CSVRecord input) {
            Long len;
            String path = input.get("jcr:path");
            String mimeType = input.get("jcr:mimeType");
            String encoding = input.get("jcr:encoding");
            String blobId = input.get(CSVFileBinaryResourceProvider.BLOB_ID);
            String length = input.get(CSVFileBinaryResourceProvider.LENGTH);
            Long l = len = length != null ? Longs.tryParse(length) : null;
            if (path == null || blobId == null || mimeType == null) {
                CSVFileBinaryResourceProvider.this.log.warn("Ignoring invalid record {}. Either of mimeType, blobId or path is null", (Object)input);
                return null;
            }
            return new BinaryResource(new BlobStoreByteSource(CSVFileBinaryResourceProvider.this.blobStore, blobId, len), mimeType, encoding, path, blobId);
        }
    }
}

