/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.base.Charsets;
import com.google.common.collect.FluentIterable;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import org.apache.commons.csv.CSVPrinter;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResource;
import org.apache.jackrabbit.oak.plugins.tika.CSVFileBinaryResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileGenerator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private File outFile;

    public CSVFileGenerator(File outFile) {
        this.outFile = outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(FluentIterable<BinaryResource> binaries) throws IOException {
        Closer closer = Closer.create();
        int count = 0;
        try {
            CSVPrinter printer = new CSVPrinter(Files.newWriter(this.outFile, Charsets.UTF_8), CSVFileBinaryResourceProvider.FORMAT);
            for (BinaryResource br : binaries) {
                ++count;
                printer.printRecord(br.getBlobId(), br.getByteSource().size(), br.getMimeType(), br.getEncoding(), br.getPath());
            }
            printer.flush();
            this.log.info("Generated csv output at {} with {} entries", (Object)this.outFile.getAbsolutePath(), (Object)count);
        }
        finally {
            closer.close();
        }
    }
}

