/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResource;
import org.apache.jackrabbit.oak.plugins.tika.BinaryResourceProvider;
import org.apache.jackrabbit.oak.plugins.tika.BlobStoreByteSource;
import org.apache.jackrabbit.oak.plugins.tree.TreeFactory;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeStoreBinaryResourceProvider
implements BinaryResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(NodeStoreBinaryResourceProvider.class);
    private final NodeStore nodeStore;
    private final BlobStore blobStore;

    public NodeStoreBinaryResourceProvider(NodeStore nodeStore, BlobStore blobStore) {
        this.nodeStore = nodeStore;
        this.blobStore = blobStore;
    }

    @Override
    public FluentIterable<BinaryResource> getBinaries(String path) {
        return new OakTreeTraverser().preOrderTraversal(TreeFactory.createReadOnlyTree(NodeStateUtils.getNode(this.nodeStore.getRoot(), path))).transform(new TreeToBinarySource()).filter(Predicates.notNull());
    }

    @CheckForNull
    private static String getString(Tree tree, String name) {
        PropertyState prop = tree.getProperty(name);
        return prop != null ? prop.getValue(Type.STRING) : null;
    }

    private static class OakTreeTraverser
    extends TreeTraverser<Tree> {
        private OakTreeTraverser() {
        }

        @Override
        public Iterable<Tree> children(Tree root) {
            return root.getChildren();
        }
    }

    private class TreeToBinarySource
    implements Function<Tree, BinaryResource> {
        private TreeToBinarySource() {
        }

        @Override
        @Nullable
        public BinaryResource apply(Tree tree) {
            PropertyState data = tree.getProperty("jcr:data");
            if (data == null) {
                return null;
            }
            if (data.isArray()) {
                log.debug("Ignoring jcr:data property at {} as its a MVP", (Object)tree.getPath());
                return null;
            }
            Blob blob = data.getValue(Type.BINARY);
            String blobId = blob.getContentIdentity();
            if (blob.getReference() == null || blobId == null) {
                log.debug("Ignoring jcr:data property at {} as its an inlined blob", (Object)tree.getPath());
                return null;
            }
            String mimeType = NodeStoreBinaryResourceProvider.getString(tree, "jcr:mimeType");
            String encoding = NodeStoreBinaryResourceProvider.getString(tree, "jcr:encoding");
            return new BinaryResource(new BlobStoreByteSource(NodeStoreBinaryResourceProvider.this.blobStore, blobId), mimeType, encoding, tree.getPath(), blobId);
        }
    }
}

