/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import com.mongodb.MongoClientURI;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.aws.ext.ds.S3DataStore;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreTextWriter;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.tika.BinaryStats;
import org.apache.jackrabbit.oak.plugins.tika.CSVFileBinaryResourceProvider;
import org.apache.jackrabbit.oak.plugins.tika.CSVFileGenerator;
import org.apache.jackrabbit.oak.plugins.tika.NodeStoreBinaryResourceProvider;
import org.apache.jackrabbit.oak.plugins.tika.TextExtractor;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractorMain {
    private static final Logger log = LoggerFactory.getLogger(TextExtractorMain.class);

    public static void main(String[] args) throws Exception {
        Closer closer = Closer.create();
        String h = "tika [extract|report|generate]\n\nreport   : Generates a summary report related to binary data\nextract  : Performs the text extraction\ngenerate : Generates the csv data file based on configured NodeStore/BlobStore";
        try {
            OptionParser parser = new OptionParser();
            AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
            ArgumentAcceptingOptionSpec<String> nodeStoreSpec = parser.accepts("nodestore", "NodeStore detail /path/to/oak/repository | mongodb://host:port/database").withRequiredArg().ofType(String.class);
            ArgumentAcceptingOptionSpec<String> pathSpec = parser.accepts("path", "Path in repository under which the binaries would be searched").withRequiredArg().ofType(String.class);
            ArgumentAcceptingOptionSpec<File> dataFileSpec = parser.accepts("data-file", "Data file in csv format containing the binary metadata").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<File> tikaConfigSpec = parser.accepts("tika-config", "Tika config file path").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<File> fdsDirSpec = parser.accepts("fds-path", "Path of directory used by FileDataStore").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<File> s3ConfigSpec = parser.accepts("s3-config-path", "Path of properties file containing config for S3DataStore").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<File> storeDirSpec = parser.accepts("store-path", "Path of directory used to store extracted text content").withRequiredArg().ofType(File.class);
            ArgumentAcceptingOptionSpec<Integer> poolSize = parser.accepts("pool-size", "Size of the thread pool used to perform text extraction. Defaults to number of cores on the system").withRequiredArg().ofType(Integer.class);
            NonOptionArgumentSpec<String> nonOption = parser.nonOptions(h);
            OptionSet options = parser.parse(args);
            List nonOptions = nonOption.values(options);
            if (options.has(help)) {
                parser.printHelpOn(System.out);
                System.exit(0);
            }
            if (nonOptions.isEmpty()) {
                parser.printHelpOn(System.err);
                System.exit(1);
            }
            boolean report = nonOptions.contains("report");
            boolean extract = nonOptions.contains("extract");
            boolean generate = nonOptions.contains("generate");
            File dataFile = null;
            File storeDir = null;
            File tikaConfigFile = null;
            DataStoreBlobStore blobStore = null;
            CSVFileBinaryResourceProvider binaryResourceProvider = null;
            BinaryStats stats = null;
            String path = "/";
            if (options.has(tikaConfigSpec)) {
                tikaConfigFile = (File)tikaConfigSpec.value(options);
                Preconditions.checkArgument(tikaConfigFile.exists(), "Tika config file %s does not exist", tikaConfigFile.getAbsolutePath());
            }
            if (options.has(storeDirSpec) && (storeDir = (File)storeDirSpec.value(options)).exists()) {
                Preconditions.checkArgument(storeDir.isDirectory(), "Path [%s] specified for storing extracted text content '%s' is not a directory", storeDir.getAbsolutePath(), storeDirSpec.options());
            }
            if (options.has(fdsDirSpec)) {
                File fdsDir = (File)fdsDirSpec.value(options);
                Preconditions.checkArgument(fdsDir.exists(), "FileDataStore %s does not exist", fdsDir.getAbsolutePath());
                FileDataStore fds = new FileDataStore();
                fds.setPath(fdsDir.getAbsolutePath());
                fds.init(null);
                blobStore = new DataStoreBlobStore(fds);
            }
            if (options.has(s3ConfigSpec)) {
                File s3Config = (File)s3ConfigSpec.value(options);
                Preconditions.checkArgument(s3Config.exists() && s3Config.canRead(), "S3DataStore config cannot be read from [%s]", s3Config.getAbsolutePath());
                Properties props = TextExtractorMain.loadProperties(s3Config);
                log.info("Loaded properties for S3DataStore from {}", (Object)s3Config.getAbsolutePath());
                String pathProp = "path";
                String repoPath = props.getProperty(pathProp);
                Preconditions.checkNotNull(repoPath, "Missing required property [%s] from S3DataStore config loaded from [%s]", pathProp, s3Config);
                String secretConfig = "secret";
                if (props.getProperty(secretConfig) == null) {
                    props.setProperty(secretConfig, UUID.randomUUID().toString());
                }
                log.info("Using {} for S3DataStore ", (Object)repoPath);
                DataStore ds = TextExtractorMain.createS3DataStore(props);
                PropertiesUtil.populate(ds, TextExtractorMain.toMap(props), false);
                ds.init(pathProp);
                blobStore = new DataStoreBlobStore(ds);
                closer.register(TextExtractorMain.asCloseable(ds));
            }
            if (options.has(dataFileSpec)) {
                dataFile = (File)dataFileSpec.value(options);
            }
            Preconditions.checkNotNull(dataFile, "Data file not configured with %s", dataFileSpec);
            if (report || extract) {
                Preconditions.checkArgument(dataFile.exists(), "Data file %s does not exist", dataFile.getAbsolutePath());
                binaryResourceProvider = new CSVFileBinaryResourceProvider(dataFile, blobStore);
                if (binaryResourceProvider instanceof Closeable) {
                    closer.register((Closeable)binaryResourceProvider);
                }
                stats = new BinaryStats(tikaConfigFile, binaryResourceProvider);
                String summary = stats.getSummary();
                log.info(summary);
            }
            if (generate) {
                String src = (String)nodeStoreSpec.value(options);
                Preconditions.checkNotNull(blobStore, "BlobStore found to be null. FileDataStore directory must be specified via %s", fdsDirSpec.options());
                Preconditions.checkNotNull(dataFile, "Data file path not provided");
                NodeStore nodeStore = TextExtractorMain.bootStrapNodeStore(src, blobStore, closer);
                NodeStoreBinaryResourceProvider brp = new NodeStoreBinaryResourceProvider(nodeStore, blobStore);
                CSVFileGenerator generator = new CSVFileGenerator(dataFile);
                generator.generate(brp.getBinaries(path));
            }
            if (extract) {
                Preconditions.checkNotNull(storeDir, "Directory to store extracted text content must be specified via %s", storeDirSpec.options());
                Preconditions.checkNotNull(blobStore, "BlobStore found to be null. FileDataStore directory must be specified via %s", fdsDirSpec.options());
                DataStoreTextWriter writer = new DataStoreTextWriter(storeDir, false);
                TextExtractor extractor = new TextExtractor(writer);
                if (options.has(poolSize)) {
                    extractor.setThreadPoolSize((Integer)poolSize.value(options));
                }
                if (tikaConfigFile != null) {
                    extractor.setTikaConfig(tikaConfigFile);
                }
                if (options.has(pathSpec)) {
                    path = (String)pathSpec.value(options);
                }
                closer.register(writer);
                closer.register(extractor);
                extractor.setStats(stats);
                log.info("Using path {}", (Object)path);
                extractor.extract(binaryResourceProvider.getBinaries(path));
                extractor.close();
                writer.close();
            }
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    private static Map<String, ?> toMap(Properties properties) {
        HashMap<String, String> map = Maps.newHashMap();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    private static DataStore createS3DataStore(Properties props) throws IOException {
        S3DataStore s3ds = new S3DataStore();
        s3ds.setProperties(props);
        return s3ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(File s3Config) throws IOException {
        Properties props = new Properties();
        FileInputStream is = FileUtils.openInputStream(s3Config);
        try {
            props.load(is);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        return props;
    }

    private static NodeStore bootStrapNodeStore(String src, BlobStore blobStore, Closer closer) throws IOException {
        if (src.startsWith("mongodb://")) {
            MongoClientURI uri = new MongoClientURI(src);
            if (uri.getDatabase() == null) {
                System.err.println("Database missing in MongoDB URI: " + uri.getURI());
                System.exit(1);
            }
            MongoConnection mongo = new MongoConnection(uri.getURI());
            closer.register(TextExtractorMain.asCloseable(mongo));
            DocumentNodeStore store = new DocumentMK.Builder().setBlobStore(blobStore).setMongoDB(mongo.getDB()).getNodeStore();
            closer.register(TextExtractorMain.asCloseable(store));
            return store;
        }
        FileStore fs = FileStoreHelper.openFileStore(src, false, blobStore);
        closer.register(TextExtractorMain.asCloseable(fs));
        return SegmentNodeStore.newSegmentNodeStore(fs).create();
    }

    private static Closeable asCloseable(final FileStore fs) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                fs.close();
            }
        };
    }

    private static Closeable asCloseable(final DataStore ds) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                try {
                    ds.close();
                }
                catch (DataStoreException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    private static Closeable asCloseable(final DocumentNodeStore dns) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                dns.dispose();
            }
        };
    }

    private static Closeable asCloseable(final MongoConnection con) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                con.close();
            }
        };
    }
}

