/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.tika;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.tika.TextExtractor;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class TikaHelper {
    private static final String DEFAULT_TIKA_CONFIG = "/org/apache/jackrabbit/oak/plugins/index/lucene/tika-config.xml";
    private static final Logger log = LoggerFactory.getLogger(TikaHelper.class);
    private final AutoDetectParser parser;
    private final Set<MediaType> supportedMediaTypes;
    private static AtomicBoolean supportedTypesLogged = new AtomicBoolean();

    public TikaHelper(@Nullable File tikaConfig) throws IOException {
        try {
            this.parser = new AutoDetectParser(TikaHelper.getTikaConfig(tikaConfig));
            this.supportedMediaTypes = this.parser.getSupportedTypes(new ParseContext());
            TikaHelper.logSupportedTypesOnce(this.supportedMediaTypes);
        }
        catch (TikaException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean isSupportedMediaType(String type) {
        return this.supportedMediaTypes.contains(MediaType.parse(type));
    }

    public boolean isIndexed(String type) {
        if (!this.isSupportedMediaType(type)) {
            return false;
        }
        MediaType mediaType = MediaType.parse(type);
        Parser p = TikaHelper.getSupportingParser(this.parser, mediaType);
        if (p == null) {
            return false;
        }
        return !((p = TikaHelper.unwrap(p)) instanceof EmptyParser);
    }

    private static TikaConfig getTikaConfig(File tikaConfig) throws TikaException, IOException, SAXException {
        TikaConfig config;
        if (tikaConfig == null) {
            URL configUrl = TextExtractor.class.getResource(DEFAULT_TIKA_CONFIG);
            if (configUrl != null) {
                log.info("Loading default Tika config from {}", (Object)configUrl);
                config = new TikaConfig(configUrl);
            } else {
                log.info("Using default Tika config");
                config = TikaConfig.getDefaultConfig();
            }
        } else {
            log.info("Loading external Tika config from {}", (Object)tikaConfig);
            config = new TikaConfig(tikaConfig);
        }
        return config;
    }

    private static Parser getSupportingParser(Parser p, MediaType mediaType) {
        if (p instanceof CompositeParser) {
            Map<MediaType, Parser> parsers = ((CompositeParser)p).getParsers();
            return TikaHelper.getSupportingParser(parsers.get(mediaType), mediaType);
        }
        return p;
    }

    private static Parser unwrap(Parser p) {
        if (p instanceof ParserDecorator) {
            return TikaHelper.unwrap(((ParserDecorator)p).getWrappedParser());
        }
        return p;
    }

    private static void logSupportedTypesOnce(Set<MediaType> supportedMediaTypes) {
        boolean alreadyLogged = supportedTypesLogged.getAndSet(true);
        if (!alreadyLogged) {
            log.info("Supported media types {}", (Object)supportedMediaTypes);
        }
    }
}

