/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.text.ParseException;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.NotFullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextParser;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class FullTextSearchImpl
extends ConstraintImpl {
    public static final boolean JACKRABBIT_2_SINGLE_QUOTED_PHRASE = true;
    final String selectorName;
    private final String relativePath;
    final String propertyName;
    final StaticOperandImpl fullTextSearchExpression;
    private SelectorImpl selector;

    public FullTextSearchImpl(String selectorName, String propertyName, StaticOperandImpl fullTextSearchExpression) {
        this.selectorName = selectorName;
        int slash = -1;
        if (propertyName != null) {
            slash = propertyName.lastIndexOf(47);
        }
        if (slash == -1) {
            this.relativePath = null;
        } else {
            this.relativePath = propertyName.substring(0, slash);
            propertyName = propertyName.substring(slash + 1);
        }
        this.propertyName = propertyName == null || "*".equals(propertyName) ? null : propertyName;
        this.fullTextSearchExpression = fullTextSearchExpression;
    }

    public StaticOperandImpl getFullTextSearchExpression() {
        return this.fullTextSearchExpression;
    }

    @Override
    ConstraintImpl not() {
        return new NotFullTextSearchImpl(this);
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("contains(");
        builder.append(this.quote(this.selectorName));
        builder.append('.');
        String pn = this.propertyName;
        if (pn == null) {
            pn = "*";
        }
        if (this.relativePath != null) {
            pn = this.relativePath + "/" + pn;
        }
        builder.append(this.quote(pn));
        builder.append(", ");
        builder.append(this.getFullTextSearchExpression());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        if (this.propertyName == null) {
            return Collections.emptySet();
        }
        String fullName = this.relativePath != null ? PathUtils.concat(this.relativePath, this.propertyName) : this.propertyName;
        return Collections.singleton(new PropertyExistenceImpl(this.selector, this.selectorName, fullName));
    }

    @Override
    public FullTextExpression getFullTextConstraint(SelectorImpl s) {
        if (!s.equals(this.selector)) {
            return null;
        }
        PropertyValue v = this.fullTextSearchExpression.currentValue();
        try {
            String p = this.propertyName;
            if (this.relativePath != null) {
                if (p == null) {
                    p = "*";
                }
                p = PathUtils.concat(this.relativePath, p);
            }
            String p2 = this.normalizePropertyName(p);
            String rawText = this.getRawText(v);
            FullTextExpression e = FullTextParser.parse(p2, rawText);
            return new FullTextContains(p2, rawText, e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid expression: " + this.fullTextSearchExpression, e);
        }
    }

    String getRawText(PropertyValue v) {
        return v.getValue(Type.STRING);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    boolean enforcePropertyExistence(String propertyName, SelectorImpl selector) {
        PropertyValue p = selector.currentProperty(propertyName);
        return p != null;
    }

    @Override
    public boolean evaluate() {
        if (this.selector.getIndex() instanceof QueryIndex.FulltextQueryIndex) {
            if (this.relativePath == null && this.propertyName != null) {
                return this.enforcePropertyExistence(this.propertyName, this.selector);
            }
            return true;
        }
        if (!this.query.getSettings().getFullTextComparisonWithoutIndex()) {
            return false;
        }
        StringBuilder buff = new StringBuilder();
        if (this.relativePath == null && this.propertyName != null) {
            PropertyValue p = this.selector.currentProperty(this.propertyName);
            if (p == null) {
                return false;
            }
            FullTextSearchImpl.appendString(buff, p);
        } else {
            Tree tree;
            String path = this.selector.currentPath();
            if (!PathUtils.denotesRoot(path)) {
                FullTextSearchImpl.appendString(buff, PropertyValues.newString(PathUtils.getName(path)));
            }
            if (this.relativePath != null) {
                String rp = this.normalizePath(this.relativePath);
                path = PathUtils.concat(path, rp);
            }
            if ((tree = this.selector.getTree(path)) == null || !tree.exists()) {
                return false;
            }
            if (this.propertyName != null) {
                String pn = this.normalizePropertyName(this.propertyName);
                PropertyState propertyState = tree.getProperty(pn);
                if (propertyState == null) {
                    return false;
                }
                FullTextSearchImpl.appendString(buff, PropertyValues.create(propertyState));
            } else {
                for (PropertyState propertyState : tree.getProperties()) {
                    FullTextSearchImpl.appendString(buff, PropertyValues.create(propertyState));
                }
            }
        }
        return this.getFullTextConstraint(this.selector).evaluate(buff.toString());
    }

    @Override
    public boolean evaluateStop() {
        if (this.selector.getIndex() instanceof QueryIndex.FulltextQueryIndex) {
            return false;
        }
        return !this.query.getSettings().getFullTextComparisonWithoutIndex();
    }

    private static void appendString(StringBuilder buff, PropertyValue p) {
        if (p.isArray()) {
            if (p.getType() != Type.BINARIES) {
                for (String v : p.getValue(Type.STRINGS)) {
                    buff.append(v).append(' ');
                }
            }
        } else if (p.getType() != Type.BINARY) {
            buff.append(p.getValue(Type.STRING)).append(' ');
        }
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (this.propertyName != null && f.getSelector().equals(this.selector)) {
            String p = this.propertyName;
            if (this.relativePath != null) {
                p = PathUtils.concat(p, this.relativePath);
            }
            p = this.normalizePropertyName(p);
            this.restrictPropertyOnFilter(p, f);
        }
        f.restrictFulltextCondition(this.fullTextSearchExpression.currentValue().getValue(Type.STRING));
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            this.selector.restrictSelector(this);
        }
    }

    void restrictPropertyOnFilter(String propertyName, FilterImpl f) {
        f.restrictProperty(propertyName, Operator.NOT_EQUAL, null);
    }

    @Override
    public AstElement copyOf() {
        return new FullTextSearchImpl(this.selectorName, this.propertyName, this.fullTextSearchExpression);
    }

    @Override
    public boolean requiresFullTextIndex() {
        return true;
    }
}

