/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;

public class LowerCaseImpl
extends DynamicOperandImpl {
    private final DynamicOperandImpl operand;

    public LowerCaseImpl(DynamicOperandImpl operand) {
        this.operand = operand;
    }

    public DynamicOperandImpl getOperand() {
        return this.operand;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "lower(" + this.operand + ')';
    }

    @Override
    public PropertyExistenceImpl getPropertyExistence() {
        return this.operand.getPropertyExistence();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.operand.getSelectors();
    }

    @Override
    public PropertyValue currentProperty() {
        PropertyValue p = this.operand.currentProperty();
        if (p == null) {
            return null;
        }
        if (p.getType().isArray()) {
            Iterable<String> lowerCase = Iterables.transform(p.getValue(Type.STRINGS), new Function<String, String>(){

                @Override
                public String apply(String input) {
                    return input.toLowerCase();
                }
            });
            return PropertyValues.newString(lowerCase);
        }
        String value = p.getValue(Type.STRING);
        return PropertyValues.newString(value.toLowerCase());
    }

    @Override
    public void restrict(FilterImpl f, Operator operator, PropertyValue v) {
        this.operand.restrict(f, Operator.NOT_EQUAL, null);
    }

    @Override
    public void restrictList(FilterImpl f, List<PropertyValue> list) {
        this.operand.restrict(f, Operator.NOT_EQUAL, null);
    }

    @Override
    public boolean canRestrictSelector(SelectorImpl s) {
        return this.operand.canRestrictSelector(s);
    }

    @Override
    int getPropertyType() {
        return 1;
    }

    @Override
    public DynamicOperandImpl createCopy() {
        return new LowerCaseImpl(this.operand.createCopy());
    }
}

