/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstElementFactory;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class NotImpl
extends ConstraintImpl {
    private ConstraintImpl constraint;

    public NotImpl(ConstraintImpl constraint) {
        this.constraint = constraint;
    }

    public ConstraintImpl getConstraint() {
        return this.constraint;
    }

    @Override
    public ConstraintImpl simplify() {
        ConstraintImpl simple = this.constraint.simplify();
        ConstraintImpl not = simple.not();
        if (not != null) {
            return not.simplify();
        }
        if (simple != this.constraint) {
            return new NotImpl(simple);
        }
        return this;
    }

    @Override
    ConstraintImpl not() {
        return this.constraint;
    }

    @Override
    public boolean evaluate() {
        return !this.constraint.evaluate();
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return this.constraint.getSelectors();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "not " + this.protect(this.constraint);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().isOuterJoinRightHandSide()) {
            return;
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
    }

    @Override
    public AstElement copyOf() {
        return new NotImpl((ConstraintImpl)AstElementFactory.copyElementAndCheckReference(this.constraint));
    }

    @Override
    public boolean requiresFullTextIndex() {
        return this.constraint.requiresFullTextIndex();
    }

    @Override
    public boolean containsUnfilteredFullTextCondition() {
        return this.constraint.requiresFullTextIndex() || this.constraint.requiresFullTextIndex();
    }
}

