/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.Operator;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;

public class SimilarImpl
extends ConstraintImpl {
    public static final String NATIVE_LUCENE_LANGUAGE = "lucene";
    public static final String MORE_LIKE_THIS_PREFIX = "mlt?mlt.fl=:path&mlt.mindf=0&stream.body=";
    private final String selectorName;
    private final String propertyName;
    private final StaticOperandImpl pathExpression;
    private SelectorImpl selector;

    SimilarImpl(String selectorName, String propertyName, StaticOperandImpl pathExpression) {
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.pathExpression = pathExpression;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("similar(");
        builder.append(this.quote(this.selectorName));
        if (this.propertyName != null) {
            builder.append(".").append(this.propertyName);
        }
        builder.append(", ");
        builder.append(this.getPathExpression());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public boolean evaluate() {
        if (!(this.selector.getIndex() instanceof QueryIndex.FulltextQueryIndex)) {
            throw new IllegalArgumentException("No full-text index was found that can process the condition " + this.toString());
        }
        PropertyValue p = this.pathExpression.currentValue();
        String path = p.getValue(Type.STRING);
        if (this.selector.getTree(path) == null) {
            return false;
        }
        return this.propertyName == null || this.selector.currentProperty(this.propertyName) != null;
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.selector)) {
            PropertyValue p = this.pathExpression.currentValue();
            String path = p.getValue(Type.STRING);
            String query = MORE_LIKE_THIS_PREFIX + path;
            PropertyValue v = PropertyValues.newString(query);
            f.restrictProperty("native*lucene", Operator.EQUAL, v);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.equals(this.selector)) {
            this.selector.restrictSelector(this);
        }
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.emptySet();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    public StaticOperandImpl getPathExpression() {
        return this.pathExpression;
    }

    @Override
    public AstElement copyOf() {
        return new SimilarImpl(this.selectorName, this.propertyName, this.pathExpression);
    }

    @Override
    public boolean requiresFullTextIndex() {
        return true;
    }
}

