/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.facet;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;

public class FacetResult {
    private final Map<String, List<Facet>> perDimFacets = new HashMap<String, List<Facet>>();

    public FacetResult(QueryResult queryResult) {
        try {
            RowIterator rows = queryResult.getRows();
            if (rows.hasNext()) {
                Row row = rows.nextRow();
                for (String column : queryResult.getColumnNames()) {
                    if (!column.startsWith("rep:facet")) continue;
                    String dimension = column.substring("rep:facet".length() + 1, column.length() - 1);
                    Value value = row.getValue(column);
                    if (value == null) continue;
                    String jsonFacetString = value.getString();
                    this.parseJson(dimension, jsonFacetString);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void parseJson(String dimension, String jsonFacetString) {
        int c;
        JsopTokenizer jsopTokenizer = new JsopTokenizer(jsonFacetString);
        LinkedList<Facet> facets = new LinkedList<Facet>();
        String label = null;
        while ((c = jsopTokenizer.read()) != 0) {
            if (1 == c) {
                label = jsopTokenizer.getEscapedToken();
                continue;
            }
            if (2 != c) continue;
            int count = Integer.parseInt(jsopTokenizer.getEscapedToken());
            if (label != null) {
                facets.add(new Facet(label, count));
            }
            label = null;
        }
        this.perDimFacets.put(dimension, facets);
    }

    @Nonnull
    public Set<String> getDimensions() {
        return this.perDimFacets.keySet();
    }

    @CheckForNull
    public List<Facet> getFacets(@Nonnull String dimension) {
        return this.perDimFacets.get(dimension);
    }

    public static class Facet {
        private final String label;
        private final int count;

        private Facet(String label, int count) {
            this.label = label;
            this.count = count;
        }

        @Nonnull
        public String getLabel() {
            return this.label;
        }

        public int getCount() {
            return this.count;
        }
    }
}

