/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import java.util.Set;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.api.ContentSession;
import org.apache.jackrabbit.oak.remote.RemoteCredentials;
import org.apache.jackrabbit.oak.remote.RemoteLoginException;
import org.apache.jackrabbit.oak.remote.RemoteRepository;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.content.BasicContentRemoteCredentials;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteCredentials;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteRevisions;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteSession;

public class ContentRemoteRepository
implements RemoteRepository {
    private final ContentRepository contentRepository;
    private final ContentRemoteRevisions contentRemoteRevisions = new ContentRemoteRevisions();
    private final ContentRemoteBinaries contentRemoteBinaries = new ContentRemoteBinaries();

    public ContentRemoteRepository(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    @Override
    public RemoteCredentials createBasicCredentials(String user, char[] password) {
        return new BasicContentRemoteCredentials(user, password);
    }

    @Override
    public RemoteCredentials createImpersonationCredentials(Set<String> principals) {
        throw new UnsupportedOperationException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteSession login(RemoteCredentials remoteCredentials) throws RemoteLoginException {
        ContentSession session;
        ContentRemoteCredentials contentRemoteCredentials = null;
        if (remoteCredentials instanceof ContentRemoteCredentials) {
            contentRemoteCredentials = (ContentRemoteCredentials)remoteCredentials;
        }
        if (contentRemoteCredentials == null) {
            throw new IllegalArgumentException("invalid credentials");
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(Oak.class.getClassLoader());
        try {
            session = contentRemoteCredentials.login(this.contentRepository);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        return new ContentRemoteSession(session, this.contentRemoteRevisions, this.contentRemoteBinaries);
    }
}

