/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.remote.RemoteResult;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.util.ISO8601;

class ContentRemoteResult
implements RemoteResult {
    private final ContentRemoteBinaries binaries;
    private final ResultRow row;

    public ContentRemoteResult(ContentRemoteBinaries binaries, ResultRow row) {
        this.binaries = binaries;
        this.row = row;
    }

    @Override
    public RemoteValue getColumnValue(String column) {
        return this.toRemoteValue(this.row.getValue(column));
    }

    private RemoteValue toRemoteValue(PropertyValue value) {
        if (value == null) {
            return null;
        }
        Type<?> type = value.getType();
        if (type.isArray()) {
            return this.toMultiRemoteValue(value);
        }
        return this.toSingleRemoteValue(value);
    }

    private RemoteValue toSingleRemoteValue(PropertyValue value) {
        Type<?> type = value.getType();
        switch (type.tag()) {
            case 1: {
                return RemoteValue.toText(value.getValue(Type.STRING));
            }
            case 2: {
                return RemoteValue.toBinaryId(this.binaries.put(value.getValue(Type.BINARY)));
            }
            case 3: {
                return RemoteValue.toLong(value.getValue(Type.LONG));
            }
            case 4: {
                return RemoteValue.toDouble(value.getValue(Type.DOUBLE));
            }
            case 5: {
                return RemoteValue.toDate(ISO8601.parse(value.getValue(Type.DATE)).getTimeInMillis());
            }
            case 6: {
                return RemoteValue.toBoolean(value.getValue(Type.BOOLEAN));
            }
            case 7: {
                return RemoteValue.toName(value.getValue(Type.NAME));
            }
            case 8: {
                return RemoteValue.toPath(value.getValue(Type.PATH));
            }
            case 9: {
                return RemoteValue.toReference(value.getValue(Type.REFERENCE));
            }
            case 10: {
                return RemoteValue.toWeakReference(value.getValue(Type.WEAKREFERENCE));
            }
            case 11: {
                return RemoteValue.toUri(value.getValue(Type.URI));
            }
            case 12: {
                return RemoteValue.toDecimal(value.getValue(Type.DECIMAL));
            }
        }
        throw new IllegalStateException("type not supported");
    }

    private RemoteValue toMultiRemoteValue(PropertyValue value) {
        Type<?> type = value.getType();
        switch (type.tag()) {
            case 1: {
                return RemoteValue.toMultiText(value.getValue(Type.STRINGS));
            }
            case 2: {
                return RemoteValue.toMultiBinaryId(this.readBinaryValues(value));
            }
            case 3: {
                return RemoteValue.toMultiLong(value.getValue(Type.LONGS));
            }
            case 4: {
                return RemoteValue.toMultiDouble(value.getValue(Type.DOUBLES));
            }
            case 5: {
                return RemoteValue.toMultiDate(this.readDateValues(value));
            }
            case 6: {
                return RemoteValue.toMultiBoolean(value.getValue(Type.BOOLEANS));
            }
            case 7: {
                return RemoteValue.toMultiName(value.getValue(Type.NAMES));
            }
            case 8: {
                return RemoteValue.toMultiPath(value.getValue(Type.PATHS));
            }
            case 9: {
                return RemoteValue.toMultiReference(value.getValue(Type.REFERENCES));
            }
            case 10: {
                return RemoteValue.toMultiWeakReference(value.getValue(Type.WEAKREFERENCES));
            }
            case 11: {
                return RemoteValue.toMultiUri(value.getValue(Type.URIS));
            }
            case 12: {
                return RemoteValue.toMultiDecimal(value.getValue(Type.DECIMALS));
            }
        }
        throw new IllegalStateException("type not supported");
    }

    private Iterable<String> readBinaryValues(PropertyValue value) {
        ArrayList<String> result = Lists.newArrayList();
        for (Blob blob : value.getValue(Type.BINARIES)) {
            result.add(this.binaries.put(blob));
        }
        return result;
    }

    private Iterable<Long> readDateValues(PropertyValue value) {
        ArrayList<Long> result = Lists.newArrayList();
        for (String string : value.getValue(Type.DATES)) {
            result.add(ISO8601.parse(string).getTimeInMillis());
        }
        return result;
    }

    @Override
    public String getSelectorPath(String selector) {
        return this.row.getPath(selector);
    }
}

