/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CopyContentRemoteOperation
implements ContentRemoteOperation {
    private static final Logger logger = LoggerFactory.getLogger(CopyContentRemoteOperation.class);
    private final String source;
    private final String target;

    public CopyContentRemoteOperation(String source, String target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void apply(Root root) throws RemoteCommitException {
        logger.debug("performing 'copy' operation on source={}, target={}", (Object)this.source, (Object)this.target);
        Tree sourceTree = root.getTree(this.source);
        if (!sourceTree.exists()) {
            throw new RemoteCommitException("source tree does not exist");
        }
        Tree targetTree = root.getTree(this.target);
        if (targetTree.exists()) {
            throw new RemoteCommitException("target tree already exists");
        }
        Tree targetParentTree = targetTree.getParent();
        if (!targetParentTree.exists()) {
            throw new RemoteCommitException("parent of target tree does not exist");
        }
        this.copy(sourceTree, targetParentTree, targetTree.getName());
    }

    private void copy(Tree source, Tree targetParent, String targetName) {
        Tree target = targetParent.addChild(targetName);
        for (PropertyState propertyState : source.getProperties()) {
            target.setProperty(propertyState);
        }
        for (Tree tree : source.getChildren()) {
            this.copy(tree, target, tree.getName());
        }
    }
}

