/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.content;

import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteBinaries;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteOperation;
import org.apache.jackrabbit.oak.remote.content.SetPropertyHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SetContentRemoteOperation
implements ContentRemoteOperation {
    private static final Logger logger = LoggerFactory.getLogger(SetContentRemoteOperation.class);
    private final ContentRemoteBinaries binaries;
    private final String path;
    private final String name;
    private final RemoteValue value;

    public SetContentRemoteOperation(ContentRemoteBinaries binaries, String path, String name, RemoteValue value) {
        this.binaries = binaries;
        this.path = path;
        this.name = name;
        this.value = value;
    }

    @Override
    public void apply(Root root) throws RemoteCommitException {
        logger.debug("performing 'set' operation on path={}, name={}", (Object)this.path, (Object)this.name);
        Tree tree = root.getTree(this.path);
        if (!tree.exists()) {
            throw new RemoteCommitException("tree does not exist");
        }
        this.value.whenType(new SetPropertyHandler(this.binaries, root, tree, this.name));
    }
}

