/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.filter;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.remote.filter.Filter;

public class Filters {
    private Set<Filter> includes = new HashSet<Filter>();
    private Set<Filter> excludes = new HashSet<Filter>();

    public Filters(Set<String> filters) {
        if (filters == null) {
            throw new IllegalArgumentException("filter set is null");
        }
        for (String filter : filters) {
            if (filter == null) {
                throw new IllegalArgumentException("filter is null");
            }
            if (filter.length() == 0) {
                throw new IllegalArgumentException("include filter is an empty string");
            }
            if (!filter.startsWith("-") || filter.length() != 1) continue;
            throw new IllegalArgumentException("exclude filter is an empty string");
        }
        for (String filter : filters) {
            if (filter.startsWith("-")) {
                this.excludes.add(new Filter(filter.substring(1)));
                continue;
            }
            this.includes.add(new Filter(filter));
        }
        if (this.includes.isEmpty()) {
            this.includes.add(new Filter("*"));
        }
    }

    public boolean matches(String name) {
        for (Filter include : this.includes) {
            if (!include.matches(name)) continue;
            for (Filter exclude : this.excludes) {
                if (!exclude.matches(name)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

