/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteBinaryFilters;
import org.apache.jackrabbit.oak.remote.RemoteBinaryId;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;

class GetBinaryHandler
implements Handler {
    private static final String CONTENT_RANGE_HEADER = "Content-Range";
    private static final String RANGE_HEADER = "Range";
    private static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("^\\s*bytes\\s*=\\s*(.*)\\s*$");
    private static final Pattern RANGE_PATTERN = Pattern.compile("^\\s*(\\d*)\\s*(?:\\s*-\\s*(\\d*))?\\s*$");
    private static final String MULTIPART_DELIMITER = "MULTIPART-DELIMITER";
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^/binaries/(.*)$");

    GetBinaryHandler() {
    }

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        String providedBinaryId = this.readBinaryId(request);
        if (providedBinaryId == null) {
            ResponseUtils.sendBadRequest(response, "unable to read the provided binary ID");
            return;
        }
        RemoteBinaryId binaryId = session.readBinaryId(providedBinaryId);
        if (binaryId == null) {
            ResponseUtils.sendNotFound(response, "binary ID not found");
            return;
        }
        List<RemoteBinaryFilters> contentRanges = this.parseRequestRanges(request, session, binaryId);
        if (contentRanges == null) {
            this.handleFile(response, session, binaryId);
        } else if (contentRanges.size() == 1) {
            this.handleSingleRange(response, session, binaryId, contentRanges.get(0));
        } else {
            this.handleMultipleRanges(response, session, binaryId, contentRanges);
        }
    }

    private void handleFile(HttpServletResponse response, RemoteSession session, RemoteBinaryId binaryId) throws IOException {
        InputStream in = session.readBinary(binaryId, new RemoteBinaryFilters());
        long length = session.readBinaryLength(binaryId);
        response.setStatus(200);
        response.setContentType("application/octet-stream");
        response.setContentLength((int)length);
        ServletOutputStream out = response.getOutputStream();
        ByteStreams.copy(in, (OutputStream)out);
        out.close();
    }

    private void handleSingleRange(HttpServletResponse response, RemoteSession session, RemoteBinaryId binaryId, RemoteBinaryFilters range) throws IOException {
        InputStream in = session.readBinary(binaryId, range);
        long fileLength = session.readBinaryLength(binaryId);
        long rangeStart = range.getStart();
        long rangeEnd = rangeStart + range.getCount() - 1L;
        response.setStatus(206);
        response.setHeader(CONTENT_RANGE_HEADER, String.format("%d-%d/%d", rangeStart, rangeEnd, fileLength));
        response.setContentType("application/octet-stream");
        response.setContentLength((int)(rangeEnd - rangeStart + 1L));
        ServletOutputStream out = response.getOutputStream();
        ByteStreams.copy(in, (OutputStream)out);
        out.close();
    }

    private void handleMultipleRanges(HttpServletResponse response, RemoteSession session, RemoteBinaryId binaryId, List<RemoteBinaryFilters> ranges) throws IOException {
        String header;
        long fileLength = session.readBinaryLength(binaryId);
        long contentLength = 0L;
        ArrayList<String> multipartHeaders = new ArrayList<String>(ranges.size());
        for (RemoteBinaryFilters range : ranges) {
            long rangeStart = range.getStart();
            long rangeEnd = rangeStart + range.getCount() - 1L;
            header = String.format("\n--%s\nContent-Type: application/octet-streamContent-Content-Range: %d-%d/%d\n\n", MULTIPART_DELIMITER, rangeStart, rangeEnd, fileLength);
            multipartHeaders.add(header);
            contentLength += (long)header.getBytes().length;
            contentLength += range.getCount();
        }
        response.setStatus(206);
        response.setContentLength((int)contentLength);
        response.setContentType("multipart/byteranges; boundary=MULTIPART-DELIMITER");
        ServletOutputStream out = response.getOutputStream();
        Iterator<RemoteBinaryFilters> rangeIt = ranges.iterator();
        Iterator headerIt = multipartHeaders.iterator();
        while (rangeIt.hasNext() && headerIt.hasNext()) {
            RemoteBinaryFilters range = rangeIt.next();
            header = (String)headerIt.next();
            out.write(header.getBytes());
            InputStream in = session.readBinary(binaryId, range);
            ByteStreams.copy(in, (OutputStream)out);
        }
        out.close();
    }

    private String readBinaryId(HttpServletRequest request) {
        Matcher matcher = REQUEST_PATTERN.matcher(request.getPathInfo());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("handler bound at the wrong path");
    }

    private List<RemoteBinaryFilters> parseRequestRanges(HttpServletRequest request, RemoteSession session, RemoteBinaryId binaryId) {
        String headerValue = request.getHeader(RANGE_HEADER);
        if (headerValue == null) {
            return null;
        }
        Matcher matcher = RANGE_HEADER_PATTERN.matcher(headerValue);
        if (!matcher.matches()) {
            return null;
        }
        headerValue = matcher.group(1);
        StringTokenizer tokenizer = new StringTokenizer(headerValue, ",");
        LinkedList<RemoteBinaryFilters> ranges = new LinkedList<RemoteBinaryFilters>();
        long fileLength = session.readBinaryLength(binaryId);
        while (tokenizer.hasMoreTokens()) {
            RemoteBinaryFilters range = this.parseRange(tokenizer.nextToken(), fileLength);
            if (range == null) {
                return null;
            }
            ranges.add(range);
        }
        return ranges;
    }

    private RemoteBinaryFilters parseRange(String range, long fileLength) {
        long end;
        long start;
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.group(2) == null || matcher.group(2).isEmpty()) {
            start = Long.parseLong(matcher.group(1));
            end = fileLength - 1L;
        } else if (matcher.group(1).isEmpty()) {
            end = fileLength - 1L;
            start = end - Long.parseLong(matcher.group(2)) + 1L;
        } else {
            start = Long.parseLong(matcher.group(1));
            end = Long.parseLong(matcher.group(2));
        }
        if (start < 0L || end < 0L || start > end || end >= fileLength || start >= fileLength) {
            return null;
        }
        return new RemoteBinaryFilters(){

            @Override
            public long getStart() {
                return start;
            }

            @Override
            public long getCount() {
                return end - start + 1L;
            }
        };
    }
}

