/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteRevision;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.RemoteTree;
import org.apache.jackrabbit.oak.remote.RemoteTreeFilters;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.RemoteValues;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;

abstract class GetTreeHandler
implements Handler {
    GetTreeHandler() {
    }

    protected abstract String readPath(HttpServletRequest var1);

    protected abstract RemoteRevision readRevision(HttpServletRequest var1, RemoteSession var2);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        RemoteRevision revision = this.readRevision(request, session);
        if (revision == null) {
            ResponseUtils.sendGone(response, "unable to read the revision");
            return;
        }
        RemoteTree tree = session.readTree(revision, this.readPath(request), this.readFilters(request));
        if (tree == null) {
            ResponseUtils.sendNotFound(response, Collections.singletonMap("Oak-Revision", revision.asString()), "tree not found");
            return;
        }
        response.setStatus(200);
        response.setHeader("Oak-Revision", revision.asString());
        response.setContentType("application/json");
        ServletOutputStream stream = response.getOutputStream();
        JsonGenerator generator = new JsonFactory().createJsonGenerator(stream, JsonEncoding.UTF8);
        this.renderResponse(generator, tree);
        generator.flush();
        stream.close();
    }

    private void renderResponse(JsonGenerator generator, RemoteTree tree) throws IOException {
        if (tree == null) {
            generator.writeNull();
        } else {
            generator.writeStartObject();
            generator.writeFieldName("properties");
            this.renderProperties(generator, tree.getProperties());
            generator.writeFieldName("children");
            this.renderChildren(generator, tree.getChildren());
            generator.writeFieldName("hasMoreChildren");
            generator.writeBoolean(tree.hasMoreChildren());
            generator.writeEndObject();
        }
    }

    private void renderChildren(JsonGenerator generator, Map<String, RemoteTree> children) throws IOException {
        generator.writeStartObject();
        for (Map.Entry<String, RemoteTree> entry : children.entrySet()) {
            generator.writeFieldName(entry.getKey());
            this.renderResponse(generator, entry.getValue());
        }
        generator.writeEndObject();
    }

    private void renderProperties(JsonGenerator generator, Map<String, RemoteValue> properties) throws IOException {
        generator.writeStartObject();
        for (Map.Entry<String, RemoteValue> entry : properties.entrySet()) {
            generator.writeFieldName(entry.getKey());
            RemoteValues.renderJson(generator, entry.getValue());
        }
        generator.writeEndObject();
    }

    private RemoteTreeFilters readFilters(final HttpServletRequest request) {
        return new RemoteTreeFilters(){

            @Override
            public int getDepth() {
                Integer depth = GetTreeHandler.this.readDepth(request);
                if (depth == null) {
                    return super.getDepth();
                }
                return depth;
            }

            @Override
            public Set<String> getPropertyFilters() {
                Set propertyFilters = GetTreeHandler.this.readPropertyFilters(request);
                if (propertyFilters == null) {
                    return super.getPropertyFilters();
                }
                return propertyFilters;
            }

            @Override
            public Set<String> getNodeFilters() {
                Set nodeFilters = GetTreeHandler.this.readNodeFilters(request);
                if (nodeFilters == null) {
                    return super.getNodeFilters();
                }
                return nodeFilters;
            }

            @Override
            public long getBinaryThreshold() {
                Long binaryThreshold = GetTreeHandler.this.readBinaryThreshold(request);
                if (binaryThreshold == null) {
                    return super.getBinaryThreshold();
                }
                return binaryThreshold;
            }

            @Override
            public int getChildrenStart() {
                Integer childrenStart = GetTreeHandler.this.readChildrenStart(request);
                if (childrenStart == null) {
                    return super.getChildrenStart();
                }
                return childrenStart;
            }

            @Override
            public int getChildrenCount() {
                Integer childrenCount = GetTreeHandler.this.readChildrenCount(request);
                if (childrenCount == null) {
                    return super.getChildrenCount();
                }
                return childrenCount;
            }
        };
    }

    private Integer readDepth(HttpServletRequest request) {
        return this.readIntegerParameter(request, "depth");
    }

    private Set<String> readPropertyFilters(HttpServletRequest request) {
        return this.readSetParameter(request, "properties");
    }

    private Set<String> readNodeFilters(HttpServletRequest request) {
        return this.readSetParameter(request, "children");
    }

    private Long readBinaryThreshold(HttpServletRequest request) {
        return this.readLongParameter(request, "binaries");
    }

    private Integer readChildrenStart(HttpServletRequest request) {
        return this.readIntegerParameter(request, "childrenStart");
    }

    private Integer readChildrenCount(HttpServletRequest request) {
        return this.readIntegerParameter(request, "childrenCount");
    }

    private Integer readIntegerParameter(HttpServletRequest request, String name) {
        Integer result;
        String value = request.getParameter(name);
        if (value == null) {
            return null;
        }
        try {
            result = Integer.parseInt(value, 10);
        }
        catch (NumberFormatException e) {
            result = null;
        }
        return result;
    }

    private Long readLongParameter(HttpServletRequest request, String name) {
        Long result;
        String value = request.getParameter(name);
        if (value == null) {
            return null;
        }
        try {
            result = Long.parseLong(value, 10);
        }
        catch (NumberFormatException e) {
            result = null;
        }
        return result;
    }

    private Set<String> readSetParameter(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        return Sets.newHashSet(values);
    }
}

