/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteRevision;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.RemoteTree;
import org.apache.jackrabbit.oak.remote.RemoteTreeFilters;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;

abstract class HeadTreeHandler
implements Handler {
    HeadTreeHandler() {
    }

    protected abstract String readPath(HttpServletRequest var1);

    protected abstract RemoteRevision readRevision(HttpServletRequest var1, RemoteSession var2);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        RemoteRevision revision = this.readRevision(request, session);
        if (revision == null) {
            ResponseUtils.sendGone(response, "revision not found");
            return;
        }
        RemoteTree tree = session.readTree(revision, this.readPath(request), new RemoteTreeFilters());
        if (tree == null) {
            ResponseUtils.sendNotFound(response, Collections.singletonMap("Oak-Revision", revision.asString()), "tree not found");
            return;
        }
        response.setStatus(200);
        response.setHeader("Oak-Revision", revision.asString());
        response.setContentType("application/json");
    }
}

