/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteCommitException;
import org.apache.jackrabbit.oak.remote.RemoteOperation;
import org.apache.jackrabbit.oak.remote.RemoteRevision;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.RemoteValue;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;
import org.apache.jackrabbit.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PatchRevisionHandler
implements Handler {
    private static final Logger logger = LoggerFactory.getLogger(PatchRevisionHandler.class);

    PatchRevisionHandler() {
    }

    protected abstract RemoteRevision readRevision(HttpServletRequest var1, RemoteSession var2);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RemoteRevision revision;
        RemoteOperation operation;
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        RemoteRevision base = this.readRevision(request, session);
        if (base == null) {
            ResponseUtils.sendGone(response, "revision not found");
            return;
        }
        try {
            operation = this.parseOperations(session, new ObjectMapper().readTree(request.getInputStream()));
        }
        catch (Exception e) {
            operation = null;
        }
        if (operation == null) {
            ResponseUtils.sendBadRequest(response, "unable to parse the list of operations");
            return;
        }
        try {
            revision = session.commit(base, operation);
        }
        catch (RemoteCommitException e) {
            logger.warn("unable to perform the commit", e);
            ResponseUtils.sendBadRequest(response, "commit failed");
            return;
        }
        response.setStatus(201);
        response.setContentType("application/json");
        ServletOutputStream stream = response.getOutputStream();
        JsonGenerator generator = new JsonFactory().createJsonGenerator(stream, JsonEncoding.UTF8);
        this.renderResponse(generator, revision);
        generator.flush();
        stream.close();
    }

    private void renderResponse(JsonGenerator generator, RemoteRevision revision) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("revision", revision.asString());
        generator.writeEndObject();
    }

    private RemoteOperation parseOperations(RemoteSession session, JsonNode json) {
        ArrayList<RemoteOperation> operations = new ArrayList<RemoteOperation>();
        for (JsonNode child : json) {
            operations.add(this.parseOperation(session, child));
        }
        return session.createAggregateOperation(operations);
    }

    private RemoteOperation parseOperation(RemoteSession session, JsonNode json) {
        String type = this.parseStringField(json, "op");
        if (type.equals("add")) {
            return this.parseAddOperation(session, json);
        }
        if (type.equals("remove")) {
            return this.parseRemoveOperation(session, json);
        }
        if (type.equals("set")) {
            return this.parseSetOperation(session, json);
        }
        if (type.equals("unset")) {
            return this.parseUnsetOperation(session, json);
        }
        if (type.equals("copy")) {
            return this.parseCopyOperation(session, json);
        }
        if (type.equals("move")) {
            return this.parseMoveOperation(session, json);
        }
        throw new IllegalArgumentException("invalid operation type");
    }

    private RemoteOperation parseMoveOperation(RemoteSession session, JsonNode node) {
        return session.createMoveOperation(this.parseStringField(node, "from"), this.parseStringField(node, "to"));
    }

    private RemoteOperation parseCopyOperation(RemoteSession session, JsonNode node) {
        return session.createCopyOperation(this.parseStringField(node, "from"), this.parseStringField(node, "to"));
    }

    private RemoteOperation parseUnsetOperation(RemoteSession session, JsonNode node) {
        return session.createUnsetOperation(this.parseStringField(node, "path"), this.parseStringField(node, "name"));
    }

    private RemoteOperation parseSetOperation(RemoteSession session, JsonNode node) {
        return session.createSetOperation(this.parseStringField(node, "path"), this.parseStringField(node, "name"), this.parseValue(node));
    }

    private RemoteOperation parseRemoveOperation(RemoteSession session, JsonNode node) {
        return session.createRemoveOperation(this.parseStringField(node, "path"));
    }

    private RemoteOperation parseAddOperation(RemoteSession session, JsonNode json) {
        return session.createAddOperation(this.parseStringField(json, "path"), this.parsePropertiesField(json, "properties"));
    }

    private Map<String, RemoteValue> parsePropertiesField(JsonNode node, String name) {
        return this.parseProperties(node.get(name));
    }

    private Map<String, RemoteValue> parseProperties(JsonNode node) {
        HashMap<String, RemoteValue> values = new HashMap<String, RemoteValue>();
        Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            values.put(entry.getKey(), this.parseValue(entry.getValue()));
        }
        return values;
    }

    private RemoteValue parseValue(JsonNode node) {
        String type = this.parseStringField(node, "type");
        if (type.equals("string")) {
            return RemoteValue.toText(this.parseStringField(node, "value"));
        }
        if (type.equals("strings")) {
            return RemoteValue.toMultiText(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("binary")) {
            return RemoteValue.toBinary(this.parseBinaryField(node, "value"));
        }
        if (type.equals("binaries")) {
            return RemoteValue.toMultiBinary(this.parseBinaryArrayField(node, "value"));
        }
        if (type.equals("binaryId")) {
            return RemoteValue.toBinaryId(this.parseStringField(node, "value"));
        }
        if (type.equals("binaryIds")) {
            return RemoteValue.toMultiBinaryId(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("long")) {
            return RemoteValue.toLong(this.parseLongField(node, "value"));
        }
        if (type.equals("longs")) {
            return RemoteValue.toMultiLong(this.parseLongArrayField(node, "value"));
        }
        if (type.equals("double")) {
            return RemoteValue.toDouble(this.parseDoubleField(node, "value"));
        }
        if (type.equals("doubles")) {
            return RemoteValue.toMultiDouble(this.parseDoubleArrayField(node, "value"));
        }
        if (type.equals("date")) {
            return RemoteValue.toDate(this.parseLongField(node, "value"));
        }
        if (type.equals("dates")) {
            return RemoteValue.toMultiDate(this.parseLongArrayField(node, "value"));
        }
        if (type.equals("boolean")) {
            return RemoteValue.toBoolean(this.parseBooleanField(node, "value"));
        }
        if (type.equals("booleans")) {
            return RemoteValue.toMultiBoolean(this.parseBooleanArrayField(node, "value"));
        }
        if (type.equals("name")) {
            return RemoteValue.toName(this.parseStringField(node, "value"));
        }
        if (type.equals("names")) {
            return RemoteValue.toMultiName(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("path")) {
            return RemoteValue.toPath(this.parseStringField(node, "value"));
        }
        if (type.equals("paths")) {
            return RemoteValue.toMultiPath(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("reference")) {
            return RemoteValue.toReference(this.parseStringField(node, "value"));
        }
        if (type.equals("references")) {
            return RemoteValue.toMultiReference(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("weakReference")) {
            return RemoteValue.toWeakReference(this.parseStringField(node, "value"));
        }
        if (type.equals("weakReferences")) {
            return RemoteValue.toMultiWeakReference(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("uri")) {
            return RemoteValue.toUri(this.parseStringField(node, "value"));
        }
        if (type.equals("uris")) {
            return RemoteValue.toMultiUri(this.parseStringArrayField(node, "value"));
        }
        if (type.equals("decimal")) {
            return RemoteValue.toDecimal(this.parseDecimalField(node, "value"));
        }
        if (type.equals("decimals")) {
            return RemoteValue.toMultiDecimal(this.parseDecimalArrayField(node, "value"));
        }
        throw new IllegalArgumentException("invalid value type");
    }

    private BigDecimal parseDecimalField(JsonNode node, String field) {
        return this.parseDecimal(node.get(field));
    }

    private BigDecimal parseDecimal(JsonNode node) {
        return new BigDecimal(node.asText());
    }

    private Iterable<BigDecimal> parseDecimalArrayField(JsonNode node, String field) {
        return this.parseDecimalArray(node.get(field));
    }

    private Iterable<BigDecimal> parseDecimalArray(JsonNode node) {
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
        for (JsonNode element : node) {
            result.add(this.parseDecimal(element));
        }
        return result;
    }

    private boolean parseBooleanField(JsonNode node, String field) {
        return this.parseBoolean(node.get(field));
    }

    private boolean parseBoolean(JsonNode node) {
        return node.asBoolean();
    }

    private Iterable<Boolean> parseBooleanArrayField(JsonNode node, String field) {
        return this.parseBooleanArray(node.get(field));
    }

    private Iterable<Boolean> parseBooleanArray(JsonNode node) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (JsonNode element : node) {
            result.add(this.parseBoolean(element));
        }
        return result;
    }

    private double parseDoubleField(JsonNode node, String field) {
        return this.parseDouble(node.get(field));
    }

    private double parseDouble(JsonNode node) {
        return node.asDouble();
    }

    private Iterable<Double> parseDoubleArrayField(JsonNode node, String field) {
        return this.parseDoubleArray(node.get(field));
    }

    private Iterable<Double> parseDoubleArray(JsonNode node) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (JsonNode element : node) {
            result.add(this.parseDouble(element));
        }
        return result;
    }

    private long parseLongField(JsonNode node, String field) {
        return this.parseLong(node.get(field));
    }

    private long parseLong(JsonNode node) {
        return node.asLong();
    }

    private Iterable<Long> parseLongArrayField(JsonNode node, String field) {
        return this.parseLongArray(node.get(field));
    }

    private Iterable<Long> parseLongArray(JsonNode node) {
        ArrayList<Long> result = new ArrayList<Long>();
        for (JsonNode element : node) {
            result.add(this.parseLong(element));
        }
        return result;
    }

    private RemoteValue.Supplier<InputStream> parseBinaryField(JsonNode node, String field) {
        return this.parseBinary(node.get(field));
    }

    private RemoteValue.Supplier<InputStream> parseBinary(final JsonNode node) {
        return new RemoteValue.Supplier<InputStream>(){

            @Override
            public InputStream get() {
                return new ByteArrayInputStream(Base64.decode(node.asText()).getBytes());
            }
        };
    }

    private Iterable<RemoteValue.Supplier<InputStream>> parseBinaryArrayField(JsonNode node, String field) {
        return this.parseBinaryArray(node.get(field));
    }

    private Iterable<RemoteValue.Supplier<InputStream>> parseBinaryArray(JsonNode node) {
        ArrayList<RemoteValue.Supplier<InputStream>> result = new ArrayList<RemoteValue.Supplier<InputStream>>();
        for (JsonNode element : node) {
            result.add(this.parseBinary(element));
        }
        return result;
    }

    private Iterable<String> parseStringArrayField(JsonNode node, String field) {
        return this.parseStringArray(node.get(field));
    }

    private String parseStringField(JsonNode node, String field) {
        return this.parseString(node.get(field));
    }

    private Iterable<String> parseStringArray(JsonNode node) {
        ArrayList<String> result = new ArrayList<String>();
        for (JsonNode element : node) {
            result.add(this.parseString(element));
        }
        return result;
    }

    private String parseString(JsonNode node) {
        return node.asText();
    }
}

