/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.remote.http.handler;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.oak.remote.RemoteQueryParseException;
import org.apache.jackrabbit.oak.remote.RemoteResult;
import org.apache.jackrabbit.oak.remote.RemoteResults;
import org.apache.jackrabbit.oak.remote.RemoteRevision;
import org.apache.jackrabbit.oak.remote.RemoteSession;
import org.apache.jackrabbit.oak.remote.http.handler.Handler;
import org.apache.jackrabbit.oak.remote.http.handler.RemoteValues;
import org.apache.jackrabbit.oak.remote.http.handler.ResponseUtils;

abstract class SearchRevisionHandler
implements Handler {
    SearchRevisionHandler() {
    }

    protected abstract RemoteRevision readRevision(HttpServletRequest var1, RemoteSession var2);

    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RemoteResults results;
        RemoteSession session = (RemoteSession)request.getAttribute("session");
        if (session == null) {
            ResponseUtils.sendInternalServerError(response, "session not found");
            return;
        }
        RemoteRevision revision = this.readRevision(request, session);
        if (revision == null) {
            ResponseUtils.sendGone(response, "unable to read the revision");
            return;
        }
        String query = this.readQuery(request);
        if (query == null) {
            ResponseUtils.sendBadRequest(response, "query not specified");
            return;
        }
        String language = this.readLanguage(request);
        if (language == null) {
            ResponseUtils.sendBadRequest(response, "language not specified");
            return;
        }
        Long offset = this.readOffset(request);
        if (offset == null) {
            ResponseUtils.sendBadRequest(response, "offset not specified");
            return;
        }
        Long limit = this.readLimit(request);
        if (limit == null) {
            ResponseUtils.sendBadRequest(response, "limit not specified");
            return;
        }
        try {
            results = session.search(revision, query, language, offset, limit);
        }
        catch (RemoteQueryParseException e) {
            ResponseUtils.sendBadRequest(response, "malformed query");
            return;
        }
        response.setStatus(200);
        response.setHeader("Oak-Revision", revision.asString());
        response.setContentType("application/json");
        ServletOutputStream stream = response.getOutputStream();
        JsonGenerator generator = new JsonFactory().createJsonGenerator(stream, JsonEncoding.UTF8);
        this.renderResponse(generator, results);
        generator.flush();
        stream.close();
    }

    private String readQuery(HttpServletRequest request) {
        return this.readStringParameter(request, "query");
    }

    private String readLanguage(HttpServletRequest request) {
        return this.readStringParameter(request, "language");
    }

    private String readStringParameter(HttpServletRequest request, String name) {
        return request.getParameter(name);
    }

    private Long readOffset(HttpServletRequest request) {
        return this.readLongParameter(request, "offset");
    }

    private Long readLimit(HttpServletRequest request) {
        return this.readLongParameter(request, "limit");
    }

    private Long readLongParameter(HttpServletRequest request, String name) {
        String value = this.readStringParameter(request, name);
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void renderResponse(JsonGenerator generator, RemoteResults results) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("total");
        generator.writeNumber(results.getTotal());
        generator.writeFieldName("columns");
        this.renderStrings(generator, results.getColumns());
        generator.writeFieldName("selectors");
        this.renderStrings(generator, results.getSelectors());
        generator.writeFieldName("results");
        this.renderResults(generator, results);
        generator.writeEndObject();
    }

    private void renderStrings(JsonGenerator generator, Iterable<String> elements) throws IOException {
        generator.writeStartArray();
        for (String element : elements) {
            generator.writeString(element);
        }
        generator.writeEndArray();
    }

    private void renderResults(JsonGenerator generator, RemoteResults results) throws IOException {
        generator.writeStartArray();
        for (RemoteResult result : results) {
            this.renderResult(generator, results, result);
        }
        generator.writeEndArray();
    }

    private void renderResult(JsonGenerator generator, RemoteResults results, RemoteResult result) throws IOException {
        generator.writeStartObject();
        generator.writeFieldName("columns");
        this.renderColumns(generator, results, result);
        generator.writeFieldName("selectors");
        this.renderSelectors(generator, results, result);
        generator.writeEndObject();
    }

    private void renderColumns(JsonGenerator generator, RemoteResults results, RemoteResult result) throws IOException {
        generator.writeStartObject();
        for (String name : results.getColumns()) {
            generator.writeFieldName(name);
            RemoteValues.renderJsonOrNull(generator, result.getColumnValue(name));
        }
        generator.writeEndObject();
    }

    private void renderSelectors(JsonGenerator generator, RemoteResults results, RemoteResult result) throws IOException {
        generator.writeStartObject();
        for (String name : results.getSelectors()) {
            generator.writeFieldName(name);
            generator.writeString(result.getSelectorPath(name));
        }
        generator.writeEndObject();
    }
}

