/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.io.Closer;
import java.io.File;
import org.apache.jackrabbit.oak.plugins.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.Utils;

class BackupCommand
implements Command {
    BackupCommand() {
    }

    @Override
    public void execute(String ... args) throws Exception {
        boolean fakeBlobStore = FileStoreBackup.USE_FAKE_BLOBSTORE;
        Closer closer = Closer.create();
        try {
            FileStore.ReadOnlyStore fs = fakeBlobStore ? FileStoreHelper.openReadOnlyFileStore(new File(args[0]), FileStoreHelper.newBasicReadOnlyBlobStore()) : FileStoreHelper.openReadOnlyFileStore(new File(args[0]));
            closer.register(Utils.asCloseable(fs));
            SegmentNodeStore store = SegmentNodeStore.newSegmentNodeStore(fs).create();
            FileStoreBackup.backup(store, new File(args[1]));
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

