/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.io.File;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.file.tooling.ConsistencyChecker;
import org.apache.jackrabbit.oak.run.Command;

class CheckCommand
implements Command {
    CheckCommand() {
    }

    @Override
    public void execute(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> path = parser.accepts("path", "path to the segment store (required)").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<String> journal = parser.accepts("journal", "journal file").withRequiredArg().ofType(String.class).defaultsTo("journal.log", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Long> deep = parser.accepts("deep", "enable deep consistency checking. An optional long specifies the number of seconds between progress notifications").withOptionalArg().ofType(Long.class).defaultsTo(Long.MAX_VALUE, (Long[])new Long[0]);
        ArgumentAcceptingOptionSpec<Long> bin = parser.accepts("bin", "read the n first bytes from binary properties. -1 for all bytes.").withOptionalArg().ofType(Long.class).defaultsTo(0L, (Long[])new Long[0]);
        OptionSet options = parser.parse(args);
        if (!options.has(path)) {
            System.err.println("usage: check <options>");
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        File dir = FileStoreHelper.isValidFileStoreOrFail(new File((String)path.value(options)));
        String journalFileName = (String)journal.value(options);
        boolean fullTraversal = options.has(deep);
        long debugLevel = (Long)deep.value(options);
        long binLen = (Long)bin.value(options);
        ConsistencyChecker.checkConsistency(dir, journalFileName, fullTraversal, debugLevel, binLen);
    }
}

