/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.io.Closer;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.sql.Timestamp;
import org.apache.jackrabbit.oak.checkpoint.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.Utils;

class CheckpointsCommand
implements Command {
    CheckpointsCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: checkpoints {<path>|<mongo-uri>} [list|rm-all|rm-unreferenced|rm <checkpoint>]");
            System.exit(1);
        }
        boolean success = false;
        Closer closer = Closer.create();
        try {
            Checkpoints cps;
            String op = "list";
            if (!(args.length < 2 || "list".equals(op = args[1]) || "rm-all".equals(op) || "rm-unreferenced".equals(op) || "rm".equals(op))) {
                CheckpointsCommand.failWith("Unknown command.");
            }
            if (args[0].startsWith("mongodb://")) {
                MongoClientURI uri = new MongoClientURI(args[0]);
                MongoClient client = new MongoClient(uri);
                DocumentNodeStore store = new DocumentMK.Builder().setMongoDB(client.getDB(uri.getDatabase())).getNodeStore();
                closer.register(Utils.asCloseable(store));
                cps = Checkpoints.onDocumentMK(store);
            } else {
                FileStore store = FileStoreHelper.openFileStore(args[0]);
                closer.register(Utils.asCloseable(store));
                cps = Checkpoints.onTarMK(store);
            }
            System.out.println("Checkpoints " + args[0]);
            if ("list".equals(op)) {
                int cnt = 0;
                for (Checkpoints.CP cp : cps.list()) {
                    System.out.printf("- %s created %s expires %s%n", cp.id, new Timestamp(cp.created), new Timestamp(cp.expires));
                    ++cnt;
                }
                System.out.println("Found " + cnt + " checkpoints");
            } else if ("rm-all".equals(op)) {
                long time = System.currentTimeMillis();
                long cnt = cps.removeAll();
                time = System.currentTimeMillis() - time;
                if (cnt != -1L) {
                    System.out.println("Removed " + cnt + " checkpoints in " + time + "ms.");
                } else {
                    CheckpointsCommand.failWith("Failed to remove all checkpoints.");
                }
            } else if ("rm-unreferenced".equals(op)) {
                long time = System.currentTimeMillis();
                long cnt = cps.removeUnreferenced();
                time = System.currentTimeMillis() - time;
                if (cnt != -1L) {
                    System.out.println("Removed " + cnt + " checkpoints in " + time + "ms.");
                } else {
                    CheckpointsCommand.failWith("Failed to remove unreferenced checkpoints.");
                }
            } else if ("rm".equals(op)) {
                if (args.length != 3) {
                    CheckpointsCommand.failWith("Missing checkpoint id");
                } else {
                    String cp = args[2];
                    long time = System.currentTimeMillis();
                    int cnt = cps.remove(cp);
                    time = System.currentTimeMillis() - time;
                    if (cnt != 0) {
                        if (cnt == 1) {
                            System.out.println("Removed checkpoint " + cp + " in " + time + "ms.");
                        } else {
                            CheckpointsCommand.failWith("Failed to remove checkpoint " + cp);
                        }
                    } else {
                        CheckpointsCommand.failWith("Checkpoint '" + cp + "' not found.");
                    }
                }
            }
            success = true;
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
        finally {
            closer.close();
        }
        if (!success) {
            System.exit(1);
        }
    }

    private static void failWith(String message) {
        throw new RuntimeException(message);
    }
}

