/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.compaction.CompactionStrategy;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.file.JournalReader;
import org.apache.jackrabbit.oak.run.Command;

class CompactCommand
implements Command {
    CompactCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec<String> directoryArg = parser.nonOptions("Path to segment store (required)").ofType(String.class);
        OptionSpecBuilder forceFlag = parser.accepts("force", "Force compaction and ignore non matching segment version");
        OptionSet options = parser.parse(args);
        String path = (String)directoryArg.value(options);
        if (path == null) {
            System.err.println("Compact a file store. Usage: compact [path] <options>");
            parser.printHelpOn(System.err);
            System.exit(-1);
        }
        Stopwatch watch = Stopwatch.createStarted();
        FileStore store = FileStoreHelper.openFileStore(path, options.has(forceFlag));
        File directory = new File(path);
        try {
            boolean persistCM = Boolean.getBoolean("tar.PersistCompactionMap");
            System.out.println("Compacting " + directory);
            System.out.println("    before " + Arrays.toString(directory.list()));
            long sizeBefore = FileUtils.sizeOfDirectory(directory);
            System.out.println("    size " + IOUtils.humanReadableByteCount(sizeBefore) + " (" + sizeBefore + " bytes)");
            System.out.println("    -> compacting");
            CompactionStrategy compactionStrategy = new CompactionStrategy(false, false, CompactionStrategy.CleanupType.CLEAN_ALL, 0L, 5){

                @Override
                public boolean compacted(Callable<Boolean> setHead) throws Exception {
                    return setHead.call();
                }
            };
            compactionStrategy.setOfflineCompaction(true);
            compactionStrategy.setPersistCompactionMap(persistCM);
            store.setCompactionStrategy(compactionStrategy);
            store.compact();
        }
        finally {
            store.close();
        }
        System.out.println("    -> cleaning up");
        store = FileStoreHelper.openFileStore(path, false);
        try {
            String head;
            for (File file : store.cleanup()) {
                if (!file.exists() || file.delete()) {
                    System.out.println("    -> removed old file " + file.getName());
                    continue;
                }
                System.out.println("    -> failed to remove old file " + file.getName());
            }
            File journal = new File(directory, "journal.log");
            JournalReader journalReader = new JournalReader(journal);
            try {
                head = journalReader.iterator().next() + " root\n";
            }
            finally {
                journalReader.close();
            }
            RandomAccessFile journalFile = new RandomAccessFile(journal, "rw");
            try {
                System.out.println("    -> writing new " + journal.getName() + ": " + head);
                journalFile.setLength(0L);
                journalFile.writeBytes(head);
                journalFile.getChannel().force(false);
            }
            finally {
                journalFile.close();
            }
        }
        finally {
            store.close();
        }
        watch.stop();
        System.out.println("    after  " + Arrays.toString(directory.list()));
        long sizeAfter = FileUtils.sizeOfDirectory(directory);
        System.out.println("    size " + IOUtils.humanReadableByteCount(sizeAfter) + " (" + sizeAfter + " bytes)");
        System.out.println("    duration  " + watch.toString() + " (" + watch.elapsed(TimeUnit.SECONDS) + "s).");
    }
}

