/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.blob.BlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.blob.ReferenceCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlobReferenceRetriever;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.Utils;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;

class DumpDataStoreReferencesCommand
implements Command {
    DumpDataStoreReferencesCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... args) throws Exception {
        if (args.length == 0) {
            System.out.println("usage: dumpdatastorerefs {<path>|<mongo-uri>} <dump_path>]");
            System.exit(1);
        }
        Closer closer = Closer.create();
        try {
            BlobReferenceRetriever marker = null;
            BlobStore blobStore = null;
            if (args[0].startsWith("mongodb://")) {
                MongoClientURI uri = new MongoClientURI(args[0]);
                MongoClient client = new MongoClient(uri);
                DocumentNodeStore store = new DocumentMK.Builder().setMongoDB(client.getDB(uri.getDatabase())).getNodeStore();
                blobStore = store.getBlobStore();
                closer.register(Utils.asCloseable(store));
                marker = new DocumentBlobReferenceRetriever(store);
            } else {
                FileStore store = FileStoreHelper.openFileStore(args[0]);
                closer.register(Utils.asCloseable(store));
                marker = new SegmentBlobReferenceRetriever(store.getTracker());
            }
            String dumpPath = StandardSystemProperty.JAVA_IO_TMPDIR.value();
            if (args.length == 2) {
                dumpPath = args[1];
            }
            File dumpFile = new File(dumpPath, "marked-" + System.currentTimeMillis());
            final BufferedWriter writer = Files.newWriter(dumpFile, Charsets.UTF_8);
            final AtomicInteger count = new AtomicInteger();
            try {
                final ArrayList idBatch = Lists.newArrayListWithCapacity(1024);
                final Joiner delimJoiner = Joiner.on(",").skipNulls();
                final GarbageCollectableBlobStore gcBlobStore = blobStore != null && blobStore instanceof GarbageCollectableBlobStore ? (GarbageCollectableBlobStore)blobStore : null;
                marker.collectReferences(new ReferenceCollector(){

                    @Override
                    public void addReference(String blobId, String nodeId) {
                        try {
                            Iterator<String> idIter = null;
                            idIter = gcBlobStore != null ? gcBlobStore.resolveChunks(blobId) : Iterators.singletonIterator(blobId);
                            while (idIter.hasNext()) {
                                String id = idIter.next();
                                idBatch.add(delimJoiner.join(id, nodeId, new Object[0]));
                                count.getAndIncrement();
                                if (idBatch.size() < 1024) continue;
                                writer.append(Joiner.on(StandardSystemProperty.LINE_SEPARATOR.value()).join(idBatch));
                                writer.append(StandardSystemProperty.LINE_SEPARATOR.value());
                                writer.flush();
                                idBatch.clear();
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Error in retrieving references", e);
                        }
                    }
                });
                if (!idBatch.isEmpty()) {
                    writer.append(Joiner.on(StandardSystemProperty.LINE_SEPARATOR.value()).join(idBatch));
                    writer.append(StandardSystemProperty.LINE_SEPARATOR.value());
                    writer.flush();
                    idBatch.clear();
                }
                System.out.println(count.get() + " DataStore references dumped in " + dumpFile);
            }
            finally {
                IOUtils.closeQuietly(writer);
            }
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
        finally {
            closer.close();
        }
    }
}

