/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.io.Closer;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreHelper;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

class GarbageCommand
implements Command {
    GarbageCommand() {
    }

    @Override
    public void execute(String ... args) throws Exception {
        Closer closer = Closer.create();
        String h = "garbage mongodb://host:port/database";
        try {
            NodeStore store = Utils.bootstrapNodeStore(args, closer, h);
            if (!(store instanceof DocumentNodeStore)) {
                System.err.println("Garbage mode only available for DocumentNodeStore");
                System.exit(1);
            }
            DocumentNodeStore dns = (DocumentNodeStore)store;
            DocumentNodeStoreHelper.garbageReport(dns);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

