/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Calendar;
import java.util.Date;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentGraph;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.run.Command;

class GraphCommand
implements Command {
    GraphCommand() {
    }

    @Override
    public void execute(String ... args) throws Exception {
        Date epoch;
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec<File> directoryArg = parser.nonOptions("Path to segment store (required)").ofType(File.class);
        ArgumentAcceptingOptionSpec<File> outFileArg = parser.accepts("output", "Output file").withRequiredArg().ofType(File.class).defaultsTo(new File("segments.gdf"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<Long> epochArg = parser.accepts("epoch", "Epoch of the segment time stamps (derived from journal.log if not given)").withRequiredArg().ofType(Long.class);
        OptionSpecBuilder gcGraphArg = parser.accepts("gc", "Write the gc generation graph instead of the full graph");
        ArgumentAcceptingOptionSpec<String> regExpArg = parser.accepts("pattern", "Regular exception specifying which nodes to include (optional). Ignore when --gc is specified.").withRequiredArg().ofType(String.class);
        OptionSet options = parser.parse(args);
        File directory = (File)directoryArg.value(options);
        if (directory == null) {
            System.err.println("Dump the segment graph to a file. Usage: graph [File] <options>");
            parser.printHelpOn(System.err);
            System.exit(-1);
        }
        System.out.println("Opening file store at " + directory);
        FileStore.ReadOnlyStore fileStore = FileStoreHelper.openReadOnlyFileStore(directory);
        String regExp = (String)regExpArg.value(options);
        File outFile = (File)outFileArg.value(options);
        if (options.has(epochArg)) {
            epoch = new Date((Long)epochArg.value(options));
        } else {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(new File(directory, "journal.log").lastModified());
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            epoch = c.getTime();
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        System.out.println("Setting epoch to " + epoch);
        System.out.println("Writing graph to " + outFile.getAbsolutePath());
        FileOutputStream out = new FileOutputStream(outFile);
        if (options.has(gcGraphArg)) {
            SegmentGraph.writeGCGraph(fileStore, out);
        } else {
            SegmentGraph.writeSegmentGraph(fileStore, out, epoch, regExp);
        }
    }
}

