/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.io.File;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.file.tooling.RevisionHistory;
import org.apache.jackrabbit.oak.run.Command;

class HistoryCommand
implements Command {
    HistoryCommand() {
    }

    @Override
    public void execute(String ... args) throws Exception {
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec<File> directoryArg = parser.nonOptions("Path to segment store (required)").ofType(File.class);
        ArgumentAcceptingOptionSpec<String> journalArg = parser.accepts("journal", "journal file").withRequiredArg().ofType(String.class).defaultsTo("journal.log", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> pathArg = parser.accepts("path", "Path for which to trace the history").withRequiredArg().ofType(String.class).defaultsTo("/", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> depthArg = parser.accepts("depth", "Depth up to which to dump node states").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        OptionSet options = parser.parse(args);
        File directory = (File)directoryArg.value(options);
        if (directory == null) {
            System.err.println("Trace the history of a path. Usage: history [File] <options>");
            parser.printHelpOn(System.err);
            System.exit(-1);
        }
        String path = (String)pathArg.value(options);
        int depth = (Integer)depthArg.value(options);
        String journalName = (String)journalArg.value(options);
        File journal = new File(FileStoreHelper.isValidFileStoreOrFail(directory), journalName);
        Iterable<RevisionHistory.HistoryElement> history = new RevisionHistory(directory).getHistory(journal, path);
        for (RevisionHistory.HistoryElement historyElement : history) {
            System.out.println(historyElement.toString(depth));
        }
    }
}

