/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.util.Collections;
import java.util.Map;
import javax.jcr.Repository;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.api.ContentRepository;
import org.apache.jackrabbit.oak.http.OakServlet;
import org.apache.jackrabbit.oak.jcr.Jcr;
import org.apache.jackrabbit.oak.remote.content.ContentRemoteRepository;
import org.apache.jackrabbit.oak.remote.http.RemoteServlet;
import org.apache.jackrabbit.server.remoting.davex.JcrRemotingServlet;
import org.apache.jackrabbit.webdav.simple.SimpleWebdavServlet;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

class HttpServer {
    private final ServletContextHandler context = new ServletContextHandler();
    private final Server server;

    public HttpServer(int port) throws Exception {
        this(port, Collections.singletonMap(new Oak(), ""));
    }

    public HttpServer(int port, Map<Oak, String> oakMap) throws Exception {
        this.context.setContextPath("/");
        for (Map.Entry<Oak, String> entry : oakMap.entrySet()) {
            this.addServlets(entry.getKey(), entry.getValue());
        }
        this.server = new Server(port);
        this.server.setHandler(this.context);
        this.server.start();
    }

    public void join() throws Exception {
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    private void addServlets(Oak oak, String path) {
        Jcr jcr = new Jcr(oak);
        ContentRepository repository = jcr.createContentRepository();
        ServletHolder holder = new ServletHolder(new OakServlet(repository));
        this.context.addServlet(holder, path + "/*");
        ServletHolder remoteServlet = new ServletHolder(new RemoteServlet(new ContentRemoteRepository(repository)));
        this.context.addServlet(remoteServlet, path + "/api/*");
        final Repository jcrRepository = jcr.createRepository();
        ServletHolder webdav = new ServletHolder(new SimpleWebdavServlet(){

            @Override
            public Repository getRepository() {
                return jcrRepository;
            }
        });
        webdav.setInitParameter("resource-path-prefix", path + "/webdav");
        webdav.setInitParameter("authenticate-header", "Basic realm=\"Oak\"");
        this.context.addServlet(webdav, path + "/webdav/*");
        ServletHolder jcrremote = new ServletHolder(new JcrRemotingServlet(){

            @Override
            protected Repository getRepository() {
                return jcrRepository;
            }
        });
        jcrremote.setInitParameter("resource-path-prefix", path + "/jcrremote");
        jcrremote.setInitParameter("authenticate-header", "Basic realm=\"Oak\"");
        this.context.addServlet(jcrremote, path + "/jcrremote/*");
    }
}

