/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.run.Mode;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        Main.printProductInfo(args);
        Mode mode = Mode.SERVER;
        if (args.length > 0) {
            mode = Main.getMode(args[0]);
            if (mode == null) {
                mode = Mode.HELP;
            }
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        mode.execute(args);
    }

    public static String getProductInfo() {
        String version = Main.getProductVersion();
        if (version == null) {
            return "Apache Jackrabbit Oak";
        }
        return "Apache Jackrabbit Oak " + version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProductVersion() {
        InputStream stream = Main.class.getResourceAsStream("/META-INF/maven/org.apache.jackrabbit/oak-run/pom.properties");
        try {
            if (stream == null) {
                String string = null;
                return string;
            }
            String string = Main.getProductVersion(stream);
            return string;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    private static String getProductVersion(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            return null;
        }
        return properties.getProperty("version");
    }

    private static void printProductInfo(String[] args) {
        if (!Arrays.asList(args).contains("--quiet")) {
            System.out.println(Main.getProductInfo());
        }
    }

    private static Mode getMode(String name) {
        try {
            return Mode.valueOf(name.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

