/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import org.apache.jackrabbit.oak.run.BackupCommand;
import org.apache.jackrabbit.oak.run.BenchmarkCommand;
import org.apache.jackrabbit.oak.run.CheckCommand;
import org.apache.jackrabbit.oak.run.CheckpointsCommand;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.CompactCommand;
import org.apache.jackrabbit.oak.run.ConsoleCommand;
import org.apache.jackrabbit.oak.run.DebugCommand;
import org.apache.jackrabbit.oak.run.DumpDataStoreReferencesCommand;
import org.apache.jackrabbit.oak.run.ExploreCommand;
import org.apache.jackrabbit.oak.run.FileStoreDiffCommand;
import org.apache.jackrabbit.oak.run.FileStoreRevisionRecoveryCommand;
import org.apache.jackrabbit.oak.run.GarbageCommand;
import org.apache.jackrabbit.oak.run.GraphCommand;
import org.apache.jackrabbit.oak.run.HelpCommand;
import org.apache.jackrabbit.oak.run.HistoryCommand;
import org.apache.jackrabbit.oak.run.PrimaryCommand;
import org.apache.jackrabbit.oak.run.RecoveryCommand;
import org.apache.jackrabbit.oak.run.RepairCommand;
import org.apache.jackrabbit.oak.run.ResetClusterIdCommand;
import org.apache.jackrabbit.oak.run.RestoreCommand;
import org.apache.jackrabbit.oak.run.ScalabilityCommand;
import org.apache.jackrabbit.oak.run.ServerCommand;
import org.apache.jackrabbit.oak.run.StandbyCommand;
import org.apache.jackrabbit.oak.run.TikaCommand;
import org.apache.jackrabbit.oak.run.UpgradeCommand;

enum Mode {
    BACKUP("backup", new BackupCommand()),
    RESTORE("restore", new RestoreCommand()),
    BENCHMARK("benchmark", new BenchmarkCommand()),
    CONSOLE("console", new ConsoleCommand()),
    DEBUG("debug", new DebugCommand()),
    GRAPH("graph", new GraphCommand()),
    HISTORY("history", new HistoryCommand()),
    CHECK("check", new CheckCommand()),
    COMPACT("compact", new CompactCommand()),
    SERVER("server", new ServerCommand()),
    UPGRADE("upgrade", new UpgradeCommand()),
    SCALABILITY("scalability", new ScalabilityCommand()),
    EXPLORE("explore", new ExploreCommand()),
    PRIMARY("primary", new PrimaryCommand()),
    STANDBY("standy", new StandbyCommand()),
    CHECKPOINTS("checkpoints", new CheckpointsCommand()),
    RECOVERY("recovery", new RecoveryCommand()),
    REPAIR("repair", new RepairCommand()),
    TIKA("tika", new TikaCommand()),
    GARBAGE("garbage", new GarbageCommand()),
    TARMKDIFF("tarmkdiff", new FileStoreDiffCommand()),
    TARMKRECOVERY("tarmkrecovery", new FileStoreRevisionRecoveryCommand()),
    DUMPDATASTOREREFS("dumpdatastorerefs", new DumpDataStoreReferencesCommand()),
    RESETCLUSTERID("resetclusterid", new ResetClusterIdCommand()),
    HELP("help", new HelpCommand());

    private final String name;
    private final Command command;

    private Mode(String name, Command command) {
        this.name = name;
        this.command = command;
    }

    public String toString() {
        return this.name;
    }

    public void execute(String ... args) throws Exception {
        this.command.execute(args);
    }
}

