/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.server.StandbyServer;
import org.apache.jackrabbit.oak.run.Command;

class PrimaryCommand
implements Command {
    PrimaryCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... args) throws Exception {
        int defaultPort = 8023;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> port = parser.accepts("port", "port to listen").withRequiredArg().ofType(Integer.class).defaultsTo(8023, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Boolean> secure = parser.accepts("secure", "use secure connections").withRequiredArg().ofType(Boolean.class);
        ArgumentAcceptingOptionSpec<String> admissible = parser.accepts("admissible", "list of admissible slave host names or ip ranges").withRequiredArg().ofType(String.class);
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions("<path to repository>");
        OptionSet options = parser.parse(args);
        List nonOptions = nonOption.values(options);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if (nonOptions.isEmpty()) {
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        List<String> admissibleSlaves = options.has(admissible) ? options.valuesOf(admissible) : Collections.EMPTY_LIST;
        FileStore store = null;
        StandbyServer failoverServer = null;
        try {
            store = FileStoreHelper.openFileStore((String)nonOptions.get(0));
            failoverServer = new StandbyServer(options.has(port) ? options.valueOf(port) : 8023, store, admissibleSlaves.toArray(new String[admissibleSlaves.size()]), options.has(secure) && options.valueOf(secure) != false);
            failoverServer.startAndWait();
        }
        finally {
            if (store != null) {
                store.close();
            }
            if (failoverServer != null) {
                failoverServer.close();
            }
        }
    }
}

