/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.io.Closer;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStoreHelper;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

class RepairCommand
implements Command {
    RepairCommand() {
    }

    @Override
    public void execute(String ... args) throws Exception {
        Closer closer = Closer.create();
        String h = "repair mongodb://host:port/database path";
        try {
            DocumentNodeStore dns;
            NodeStore store = Utils.bootstrapNodeStore(args, closer, h);
            if (!(store instanceof DocumentNodeStore)) {
                System.err.println("Repair only available for DocumentNodeStore");
                System.exit(1);
            }
            if (!((dns = (DocumentNodeStore)store).getDocumentStore() instanceof MongoDocumentStore)) {
                System.err.println("Repair only available for MongoDocumentStore");
                System.exit(1);
            }
            MongoDocumentStore docStore = (MongoDocumentStore)dns.getDocumentStore();
            String path = args[args.length - 1];
            MongoDocumentStoreHelper.repair(docStore, path);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

