/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.io.Closer;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.Utils;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

public class ResetClusterIdCommand
implements Command {
    private static void deleteClusterId(NodeStore store) {
        NodeBuilder builder = store.getRoot().builder();
        NodeBuilder clusterConfigNode = builder.getChildNode(":clusterConfig");
        if (!clusterConfigNode.exists()) {
            System.out.println("clusterId was never set or already deleted.");
            return;
        }
        if (!clusterConfigNode.hasProperty(":clusterId")) {
            System.out.println("clusterId was never set or already deleted.");
            return;
        }
        String oldClusterId = clusterConfigNode.getProperty(":clusterId").getValue(Type.STRING);
        clusterConfigNode.removeProperty(":clusterId");
        try {
            store.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
            System.out.println("clusterId deleted successfully. (old id was " + oldClusterId + ")");
        }
        catch (CommitFailedException e) {
            System.err.println("Failed to delete clusterId due to exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void execute(String ... args) throws Exception {
        if (args.length != 1) {
            System.out.println("usage: resetclusterid {<path>|<mongo-uri>}");
            System.exit(1);
        }
        Closer closer = Closer.create();
        try {
            Observable store;
            if (args[0].startsWith("mongodb://")) {
                MongoClientURI uri = new MongoClientURI(args[0]);
                MongoClient client = new MongoClient(uri);
                DocumentNodeStore dns = new DocumentMK.Builder().setMongoDB(client.getDB(uri.getDatabase())).getNodeStore();
                closer.register(Utils.asCloseable(dns));
                store = dns;
            } else {
                FileStore fs = FileStoreHelper.openFileStore(args[0]);
                closer.register(Utils.asCloseable(fs));
                store = SegmentNodeStore.newSegmentNodeStore(fs).create();
            }
            ResetClusterIdCommand.deleteClusterId(store);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }
}

