/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.Oak;
import org.apache.jackrabbit.oak.fixture.OakFixture;
import org.apache.jackrabbit.oak.run.Command;
import org.apache.jackrabbit.oak.run.HttpServer;

class ServerCommand
implements Command {
    private static final String DEFAULT_URI = "http://localhost:8080/";
    private static final int MB = 0x100000;

    ServerCommand() {
    }

    private static void startOakServer(OakFixture oakFixture, String uri, List<Integer> cIds) throws Exception {
        Map<Oak, String> m;
        if (cIds.isEmpty()) {
            System.out.println("Starting " + oakFixture.toString() + " repository -> " + uri);
            m = Collections.singletonMap(oakFixture.getOak(0), "");
        } else {
            System.out.println("Starting a clustered repository " + oakFixture.toString() + " -> " + uri);
            m = new HashMap<Oak, String>(cIds.size());
            for (int i = 0; i < cIds.size(); ++i) {
                m.put(oakFixture.getOak(i), "/node" + i);
            }
        }
        new HttpServer(URI.create(uri).getPort(), m);
    }

    @Override
    public void execute(String ... args) throws Exception {
        OakFixture oakFixture;
        List arglist;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> cache = parser.accepts("cache", "cache size (MB)").withRequiredArg().ofType(Integer.class).defaultsTo(100, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<File> base = parser.accepts("base", "Base directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<Boolean> mmap = parser.accepts("mmap", "TarMK memory mapping").withOptionalArg().ofType(Boolean.class).defaultsTo("64".equals(System.getProperty("sun.arch.data.model")), (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> host = parser.accepts("host", "MongoDB host").withRequiredArg().defaultsTo("127.0.0.1", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> port = parser.accepts("port", "MongoDB port").withRequiredArg().ofType(Integer.class).defaultsTo(27017, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> dbName = parser.accepts("db", "MongoDB database").withRequiredArg();
        ArgumentAcceptingOptionSpec<Integer> clusterIds = parser.accepts("clusterIds", "Cluster Ids").withOptionalArg().ofType(Integer.class).withValuesSeparatedBy(',');
        ArgumentAcceptingOptionSpec<String> rdbjdbcuri = parser.accepts("rdbjdbcuri", "RDB JDBC URI").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcuser = parser.accepts("rdbjdbcuser", "RDB JDBC user").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcpasswd = parser.accepts("rdbjdbcpasswd", "RDB JDBC password").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbctableprefix = parser.accepts("rdbjdbctableprefix", "RDB JDBC table prefix").withOptionalArg().defaultsTo("", (String[])new String[0]);
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions();
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        OptionSet options = parser.parse(args);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        String uri = (arglist = nonOption.values(options)).isEmpty() ? DEFAULT_URI : (String)arglist.get(0);
        String fix = arglist.size() <= 1 ? "Oak-Memory" : (String)arglist.get(1);
        int cacheSize = (Integer)cache.value(options);
        List<Integer> cIds = Collections.emptyList();
        if (fix.startsWith("Oak-Memory")) {
            oakFixture = "Oak-MemoryNS".equals(fix) ? OakFixture.getMemoryNS(cacheSize * 0x100000) : OakFixture.getMemory(cacheSize * 0x100000);
        } else if (fix.startsWith("Oak-Mongo")) {
            cIds = clusterIds.values(options);
            String db = (String)dbName.value(options);
            if (db == null) {
                throw new IllegalArgumentException("Required argument db missing");
            }
            oakFixture = "Oak-MongoNS".equals(fix) ? OakFixture.getMongoNS((String)host.value(options), (Integer)port.value(options), db, false, cacheSize * 0x100000) : OakFixture.getMongo((String)host.value(options), (Integer)port.value(options), db, false, cacheSize * 0x100000);
        } else if (fix.equals("Oak-Tar")) {
            File baseFile = (File)base.value(options);
            if (baseFile == null) {
                throw new IllegalArgumentException("Required argument base missing.");
            }
            oakFixture = OakFixture.getTar("Oak-Tar", baseFile, 256, cacheSize, (Boolean)mmap.value(options), false);
        } else if (fix.equals("Oak-RDB")) {
            oakFixture = OakFixture.getRDB("Oak-RDB", (String)rdbjdbcuri.value(options), (String)rdbjdbcuser.value(options), (String)rdbjdbcpasswd.value(options), (String)rdbjdbctableprefix.value(options), false, cacheSize);
        } else {
            throw new IllegalArgumentException("Unsupported repository setup " + fix);
        }
        ServerCommand.startOakServer(oakFixture, uri, cIds);
    }
}

