/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.util.concurrent.AbstractScheduledService;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.plugins.segment.standby.client.StandbyClient;
import org.apache.jackrabbit.oak.run.Command;

class StandbyCommand
implements Command {
    StandbyCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String ... args) throws Exception {
        String defaultHost = "127.0.0.1";
        int defaultPort = 8023;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> host = parser.accepts("host", "master host").withRequiredArg().ofType(String.class).defaultsTo("127.0.0.1", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> port = parser.accepts("port", "master port").withRequiredArg().ofType(Integer.class).defaultsTo(8023, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> interval = parser.accepts("interval", "interval between successive executions").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<Boolean> secure = parser.accepts("secure", "use secure connections").withRequiredArg().ofType(Boolean.class);
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions("<path to repository>");
        OptionSet options = parser.parse(args);
        List nonOptions = nonOption.values(options);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if (nonOptions.isEmpty()) {
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        FileStore store = null;
        StandbyClient failoverClient = null;
        try {
            store = FileStoreHelper.openFileStore((String)nonOptions.get(0));
            failoverClient = new StandbyClient(options.has(host) ? options.valueOf(host) : "127.0.0.1", options.has(port) ? options.valueOf(port) : 8023, store, options.has(secure) && options.valueOf(secure) != false, 10000, false);
            if (!options.has(interval)) {
                failoverClient.run();
            } else {
                ScheduledSyncService syncService = new ScheduledSyncService(failoverClient, options.valueOf(interval));
                syncService.startAsync();
                syncService.awaitTerminated();
            }
        }
        finally {
            if (store != null) {
                store.close();
            }
            if (failoverClient != null) {
                failoverClient.close();
            }
        }
    }

    private static class ScheduledSyncService
    extends AbstractScheduledService {
        private final StandbyClient failoverClient;
        private final int interval;

        public ScheduledSyncService(StandbyClient failoverClient, int interval) {
            this.failoverClient = failoverClient;
            this.interval = interval;
        }

        @Override
        public void runOneIteration() throws Exception {
            this.failoverClient.run();
        }

        @Override
        protected AbstractScheduledService.Scheduler scheduler() {
            return AbstractScheduledService.Scheduler.newFixedDelaySchedule(0L, this.interval, TimeUnit.SECONDS);
        }
    }
}

