/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.run;

import com.google.common.io.Closer;
import com.mongodb.MongoClientURI;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.util.MongoConnection;
import org.apache.jackrabbit.oak.plugins.segment.FileStoreHelper;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeStore;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.NodeStore;

class Utils {
    Utils() {
    }

    public static NodeStore bootstrapNodeStore(String[] args, Closer closer, String h) throws IOException {
        String src;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<Integer> clusterId = parser.accepts("clusterId", "MongoMK clusterId").withRequiredArg().ofType(Integer.class).defaultsTo(0, (Integer[])new Integer[0]);
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions(h);
        OptionSet options = parser.parse(args);
        List nonOptions = nonOption.values(options);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        if (nonOptions.isEmpty()) {
            parser.printHelpOn(System.err);
            System.exit(1);
        }
        if ((src = (String)nonOptions.get(0)).startsWith("mongodb://")) {
            MongoClientURI uri = new MongoClientURI(src);
            if (uri.getDatabase() == null) {
                System.err.println("Database missing in MongoDB URI: " + uri.getURI());
                System.exit(1);
            }
            MongoConnection mongo = new MongoConnection(uri.getURI());
            closer.register(Utils.asCloseable(mongo));
            DocumentNodeStore store = new DocumentMK.Builder().setMongoDB(mongo.getDB()).setLeaseCheck(false).setClusterId((Integer)clusterId.value(options)).getNodeStore();
            closer.register(Utils.asCloseable(store));
            return store;
        }
        FileStore fs = FileStoreHelper.openFileStore(src);
        closer.register(Utils.asCloseable(fs));
        return SegmentNodeStore.newSegmentNodeStore(fs).create();
    }

    static Closeable asCloseable(final FileStore fs) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                fs.close();
            }
        };
    }

    static Closeable asCloseable(final DocumentNodeStore dns) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                dns.dispose();
            }
        };
    }

    private static Closeable asCloseable(final MongoConnection con) {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                con.close();
            }
        };
    }
}

