/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.benchmark.CSVResultGenerator;
import org.apache.jackrabbit.oak.benchmark.util.Date;
import org.apache.jackrabbit.oak.fixture.JackrabbitRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.OakRepositoryFixture;
import org.apache.jackrabbit.oak.fixture.RepositoryFixture;
import org.apache.jackrabbit.oak.scalability.ScalabilitySuite;
import org.apache.jackrabbit.oak.scalability.benchmarks.AggregateNodeSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.ConcurrentReader;
import org.apache.jackrabbit.oak.scalability.benchmarks.ConcurrentWriter;
import org.apache.jackrabbit.oak.scalability.benchmarks.FacetSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.FormatSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.FullTextSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.LastModifiedSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterOrderByKeysetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterOrderByOffsetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterOrderBySearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterSplitOrderByKeysetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterSplitOrderByOffsetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.MultiFilterSplitOrderBySearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.NodeTypeSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.OrderByDate;
import org.apache.jackrabbit.oak.scalability.benchmarks.OrderByKeysetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.OrderByOffsetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.OrderBySearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.SplitOrderByKeysetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.SplitOrderByOffsetPageSearcher;
import org.apache.jackrabbit.oak.scalability.benchmarks.SplitOrderBySearcher;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityBlobSearchSuite;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityNodeRelationshipSuite;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityNodeSuite;

public class ScalabilityRunner {
    private static final long MB = 0x100000L;

    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> base = parser.accepts("base", "Base directory").withRequiredArg().ofType(File.class).defaultsTo(new File("target"), (File[])new File[0]);
        ArgumentAcceptingOptionSpec<String> host = parser.accepts("host", "MongoDB host").withRequiredArg().defaultsTo("localhost", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Integer> port = parser.accepts("port", "MongoDB port").withRequiredArg().ofType(Integer.class).defaultsTo(27017, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<String> dbName = parser.accepts("db", "MongoDB database").withRequiredArg();
        ArgumentAcceptingOptionSpec<Boolean> dropDBAfterTest = parser.accepts("dropDBAfterTest", "Whether to drop the MongoDB database after the test").withOptionalArg().ofType(Boolean.class).defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcuri = parser.accepts("rdbjdbcuri", "RDB JDBC URI").withOptionalArg().defaultsTo("jdbc:h2:./target/benchmark", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcuser = parser.accepts("rdbjdbcuser", "RDB JDBC user").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbcpasswd = parser.accepts("rdbjdbcpasswd", "RDB JDBC password").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> rdbjdbctableprefix = parser.accepts("rdbjdbctableprefix", "RDB JDBC table prefix").withOptionalArg().defaultsTo("", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<Boolean> mmap = parser.accepts("mmap", "TarMK memory mapping").withOptionalArg().ofType(Boolean.class).defaultsTo("64".equals(System.getProperty("sun.arch.data.model")), (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Integer> cache = parser.accepts("cache", "cache size (MB)").withRequiredArg().ofType(Integer.class).defaultsTo(100, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> fdsCache = parser.accepts("blobCache", "cache size (MB)").withRequiredArg().ofType(Integer.class).defaultsTo(32, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Boolean> withStorage = parser.accepts("storage", "Index storage enabled").withOptionalArg().ofType(Boolean.class);
        ArgumentAcceptingOptionSpec<File> csvFile = parser.accepts("csvFile", "File to write a CSV version of the benchmark data.").withOptionalArg().ofType(File.class);
        AbstractOptionSpec help = parser.acceptsAll(Arrays.asList("h", "?", "help"), "show help").forHelp();
        NonOptionArgumentSpec<String> nonOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        if (options.has(help)) {
            parser.printHelpOn(System.out);
            System.exit(0);
        }
        int cacheSize = (Integer)cache.value(options);
        RepositoryFixture[] allFixtures = new RepositoryFixture[]{new JackrabbitRepositoryFixture((File)base.value(options), cacheSize), OakRepositoryFixture.getMemoryNS((long)cacheSize * 0x100000L), OakRepositoryFixture.getMongo((String)host.value(options), (Integer)port.value(options), (String)dbName.value(options), (Boolean)dropDBAfterTest.value(options), (long)cacheSize * 0x100000L), OakRepositoryFixture.getMongoWithFDS((String)host.value(options), (Integer)port.value(options), (String)dbName.value(options), (Boolean)dropDBAfterTest.value(options), (long)cacheSize * 0x100000L, (File)base.value(options), (Integer)fdsCache.value(options)), OakRepositoryFixture.getMongoNS((String)host.value(options), (Integer)port.value(options), (String)dbName.value(options), (Boolean)dropDBAfterTest.value(options), (long)cacheSize * 0x100000L), OakRepositoryFixture.getTar((File)base.value(options), 256, cacheSize, (Boolean)mmap.value(options)), OakRepositoryFixture.getTarWithBlobStore((File)base.value(options), 256, cacheSize, (Boolean)mmap.value(options)), OakRepositoryFixture.getRDB((String)rdbjdbcuri.value(options), (String)rdbjdbcuser.value(options), (String)rdbjdbcpasswd.value(options), (String)rdbjdbctableprefix.value(options), (Boolean)dropDBAfterTest.value(options), (long)cacheSize * 0x100000L), OakRepositoryFixture.getRDBWithFDS((String)rdbjdbcuri.value(options), (String)rdbjdbcuser.value(options), (String)rdbjdbcpasswd.value(options), (String)rdbjdbctableprefix.value(options), (Boolean)dropDBAfterTest.value(options), (long)cacheSize * 0x100000L, (File)base.value(options), (Integer)fdsCache.value(options))};
        ScalabilitySuite[] allSuites = new ScalabilitySuite[]{new ScalabilityBlobSearchSuite((Boolean)withStorage.value(options)).addBenchmarks(new FullTextSearcher(), new NodeTypeSearcher(), new FormatSearcher(), new FacetSearcher(), new LastModifiedSearcher(Date.LAST_2_HRS), new LastModifiedSearcher(Date.LAST_24_HRS), new LastModifiedSearcher(Date.LAST_7_DAYS), new LastModifiedSearcher(Date.LAST_MONTH), new LastModifiedSearcher(Date.LAST_YEAR), new OrderByDate()), new ScalabilityNodeSuite((Boolean)withStorage.value(options)).addBenchmarks(new OrderBySearcher(), new SplitOrderBySearcher(), new OrderByOffsetPageSearcher(), new SplitOrderByOffsetPageSearcher(), new OrderByKeysetPageSearcher(), new SplitOrderByKeysetPageSearcher(), new MultiFilterOrderBySearcher(), new MultiFilterSplitOrderBySearcher(), new MultiFilterOrderByOffsetPageSearcher(), new MultiFilterSplitOrderByOffsetPageSearcher(), new MultiFilterOrderByKeysetPageSearcher(), new MultiFilterSplitOrderByKeysetPageSearcher(), new ConcurrentReader(), new ConcurrentWriter()), new ScalabilityNodeRelationshipSuite((Boolean)withStorage.value(options)).addBenchmarks(new AggregateNodeSearcher())};
        HashSet<String> argset = Sets.newHashSet(nonOption.values(options));
        ArrayList<RepositoryFixture> fixtures = Lists.newArrayList();
        for (RepositoryFixture fixture : allFixtures) {
            if (!argset.remove(fixture.toString())) continue;
            fixtures.add(fixture);
        }
        HashMap<String, List<String>> argmap = Maps.newHashMap();
        for (String arg : argset) {
            List<String> tokens = Splitter.on(":").limit(2).splitToList(arg);
            if (tokens.size() > 1) {
                argmap.put(tokens.get(0), Splitter.on(",").trimResults().splitToList(tokens.get(1)));
            } else {
                argmap.put(tokens.get(0), null);
            }
            argset.remove(arg);
        }
        if (argmap.isEmpty()) {
            System.err.println("Warning: no scalability suites specified, supported  are: " + Arrays.asList(allSuites));
        }
        ArrayList<ScalabilitySuite> suites = Lists.newArrayList();
        for (ScalabilitySuite suite : allSuites) {
            if (!argmap.containsKey(suite.toString())) continue;
            List benchmarks = (List)argmap.get(suite.toString());
            if (benchmarks != null) {
                Iterator<String> iter = suite.getBenchmarks().keySet().iterator();
                while (iter.hasNext()) {
                    String availBenchmark = iter.next();
                    if (benchmarks.contains(availBenchmark)) continue;
                    iter.remove();
                }
            }
            suites.add(suite);
            argmap.remove(suite.toString());
        }
        if (argmap.isEmpty()) {
            PrintStream out = null;
            if (options.has(csvFile)) {
                out = new PrintStream((OutputStream)FileUtils.openOutputStream((File)csvFile.value(options), true), false, Charsets.UTF_8.name());
            }
            for (ScalabilitySuite suite : suites) {
                if (suite instanceof CSVResultGenerator) {
                    ((CSVResultGenerator)((Object)suite)).setPrintStream(out);
                }
                suite.run(fixtures);
            }
            if (out != null) {
                out.close();
            }
        } else {
            System.err.println("Unknown arguments: " + argset);
        }
    }
}

