/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.oak.scalability.benchmarks.SearchScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;

public class AggregateNodeSearcher
extends SearchScalabilityBenchmark {
    private static final String RELATIONSHIPS = "relationships";

    @Override
    protected Query getQuery(@Nonnull QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        List relationships = (List)context.getMap().get(RELATIONSHIPS);
        StringBuilder statement = new StringBuilder("");
        statement.append("/jcr:root").append("//element(*, ").append((String)context.getMap().get("rootType")).append(")");
        statement.append("[((");
        for (String relationship : relationships) {
            statement.append("sourceId").append(" = '").append(relationship).append("' or ");
        }
        statement.delete(statement.lastIndexOf(" or "), statement.length());
        statement.append("))]");
        statement.append(" order by").append(" @").append("jcr:created").append(" descending");
        LOG.debug("{}", (Object)statement);
        return qm.createQuery(statement.toString(), "xpath");
    }

    @Override
    public void execute(Repository repository, Credentials credentials, ScalabilityAbstractSuite.ExecutionContext context) throws Exception {
        Session session = repository.login(credentials);
        try {
            List users = (List)context.getMap().get("User");
            Random rand = new Random(99L);
            Authorizable user = (Authorizable)users.get(rand.nextInt(users.size()));
            List<String> targets = this.getRelatedUsers(session, user);
            context.getMap().put(RELATIONSHIPS, targets);
            QueryManager qm = session.getWorkspace().getQueryManager();
            this.search(qm, context);
            context.getMap().remove(RELATIONSHIPS);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private List<String> getRelatedUsers(Session session, Authorizable user) throws RepositoryException {
        ArrayList<String> targets = Lists.newArrayList();
        Node relRootNode = session.getNode(user.getPath() + "/" + "Relationships");
        NodeIterator children = relRootNode.getNodes();
        while (children.hasNext()) {
            Node node = children.nextNode();
            targets.add(node.getProperty("targetId").getString());
        }
        return targets;
    }
}

