/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.oak.scalability.benchmarks.ScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentReader
extends ScalabilityBenchmark {
    protected static final Logger LOG = LoggerFactory.getLogger(ConcurrentReader.class);
    private static final Random rand = new Random();
    private static final int WRITERS = Integer.getInteger("concurrentReaders", 0);
    private static final int READERS = Integer.getInteger("concurrentWriters", 0);
    private static final int MAX_ASSETS = Integer.getInteger("assets", 100);
    private static final String ROOT_NODE_NAME = ConcurrentReader.class.getSimpleName() + UUID.randomUUID();
    private boolean running;
    private List<Thread> jobs = Lists.newArrayList();

    @Override
    public void beforeExecute(Repository repository, Credentials credentials, ScalabilityAbstractSuite.ExecutionContext context) throws Exception {
        Thread thread;
        int idx;
        Session session = repository.login(credentials);
        JcrUtils.getOrAddNode(session.getRootNode(), ROOT_NODE_NAME);
        session.save();
        session.logout();
        for (idx = 0; idx < WRITERS; ++idx) {
            try {
                thread = this.createJob(new Writer("concurrentWriter-" + UUID.randomUUID() + idx, MAX_ASSETS, repository.login(credentials), context));
                this.jobs.add(thread);
                thread.start();
                continue;
            }
            catch (Exception e) {
                LOG.error("error creating background writer", e);
            }
        }
        for (idx = 0; idx < READERS; ++idx) {
            try {
                thread = this.createJob(new Reader("concurrentReader-" + UUID.randomUUID() + idx, MAX_ASSETS, repository.login(credentials), context));
                this.jobs.add(thread);
                thread.start();
                continue;
            }
            catch (Exception e) {
                LOG.error("error creating background reader", e);
            }
        }
        this.running = true;
    }

    private Thread createJob(final Job job) throws RepositoryException {
        Thread thread = new Thread(job.id){

            @Override
            public void run() {
                while (ConcurrentReader.this.running) {
                    job.process();
                }
            }
        };
        thread.setDaemon(true);
        return thread;
    }

    @Override
    public void afterExecute(Repository repository, Credentials credentials, ScalabilityAbstractSuite.ExecutionContext context) {
        this.running = false;
        for (Thread thread : this.jobs) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                LOG.error("Error stopping thread", e);
            }
        }
        this.jobs.clear();
    }

    @Override
    public void execute(Repository repository, Credentials credentials, ScalabilityAbstractSuite.ExecutionContext context) throws Exception {
        Reader reader = new Reader(this.getClass().getSimpleName() + UUID.randomUUID(), 100, repository.login(credentials), context);
        reader.process();
    }

    class Writer
    extends Job {
        Writer(String id, int maxAssets, Session session, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
            super(id, maxAssets, session, context);
        }

        @Override
        public void process() {
            try {
                for (int count = 1; count <= this.maxAssets; ++count) {
                    this.session.refresh(false);
                    Node node = JcrUtils.getOrAddNode(this.parent, "Node" + count, "oak:Unstructured");
                    node.setProperty("prop1", "val1");
                    node.setProperty("prop2", "val2");
                    this.session.save();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(node.getPath());
                }
            }
            catch (Exception e) {
                LOG.error("Exception in write", e);
            }
        }
    }

    class Reader
    extends Job {
        Reader(String id, int maxAssets, Session session, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
            super(id, maxAssets, session, context);
        }

        @Override
        public void process() {
            try {
                int readPathSize = this.readPaths.size();
                for (int count = 1; count <= this.maxAssets; ++count) {
                    this.session.refresh(false);
                    Node node = JcrUtils.getNodeIfExists((String)this.readPaths.get(this.rand.nextInt(readPathSize)), this.session);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug(node.getPath());
                }
            }
            catch (Exception e) {
                LOG.error("Exception in reading", e);
            }
        }
    }

    abstract class Job {
        final Node parent;
        final Session session;
        final String id;
        final int maxAssets;
        final List<String> readPaths;
        final Random rand;

        Job(String id, int maxAssets, Session session, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
            this.id = id;
            this.maxAssets = maxAssets;
            this.session = session;
            this.parent = session.getRootNode().getNode(ROOT_NODE_NAME).addNode(id);
            this.readPaths = (List)context.getMap().get("searchPaths");
            this.rand = new Random();
            session.save();
        }

        public abstract void process();
    }
}

