/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.scalability.benchmarks;

import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.jackrabbit.oak.benchmark.util.MimeType;
import org.apache.jackrabbit.oak.scalability.benchmarks.SearchScalabilityBenchmark;
import org.apache.jackrabbit.oak.scalability.suites.ScalabilityAbstractSuite;

public class FormatSearcher
extends SearchScalabilityBenchmark {
    @Override
    protected Query getQuery(QueryManager qm, ScalabilityAbstractSuite.ExecutionContext context) throws RepositoryException {
        StringBuilder statement = new StringBuilder("/jcr:root/");
        statement.append((String)context.getMap().get("rootNodeName")).append("//element(*, ").append(context.getMap().get("nodeType")).append(")");
        statement.append("[((");
        for (MimeType mt : MimeType.values()) {
            statement.append("jcr:content/@").append("jcr:mimeType").append(" = '").append(mt.getValue()).append("' or ");
        }
        statement.delete(statement.lastIndexOf(" or "), statement.length());
        statement.append("))]");
        LOG.debug("{}", (Object)statement);
        return qm.createQuery(statement.toString(), "xpath");
    }
}

